/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.cache.consumer;

import com.ovopark.dc.common.cache.Buffer;
import com.ovopark.dc.common.cache.consumer.IConsumer;
import com.ovopark.dc.common.cache.produce.Channel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorConsumer
extends Thread {
    protected static final Logger log = LoggerFactory.getLogger(SelectorConsumer.class);
    private List<Group> groupList = new ArrayList<Group>();
    private final long cycleTime;
    private boolean running;
    private int size;

    public SelectorConsumer(long consumerCycle, String threadName) {
        super(threadName);
        this.cycleTime = consumerCycle;
        this.running = false;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            boolean hasData = false;
            for (Group group : this.groupList) {
                boolean num = this.consumeGroup(group);
                hasData = hasData || num;
            }
            if (hasData) continue;
            try {
                Thread.sleep(this.cycleTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        for (Group group : this.groupList) {
            try {
                this.consumeGroup(group);
            }
            catch (Exception exception) {}
        }
    }

    private boolean consumeGroup(Group group) {
        Channel channel = group.channel;
        IConsumer consumer = group.consumer;
        LinkedList consumerList = new LinkedList();
        for (int index = 0; index < channel.getChannelSize(); ++index) {
            Buffer buffer = channel.getBuffer(index);
            consumerList.addAll(buffer.drain());
        }
        if (consumerList.isEmpty()) {
            return false;
        }
        try {
            consumer.consumer(consumerList);
        }
        catch (Exception exception) {
            log.error("\u6d88\u8d39\u8005\u51fa\u73b0\u5f02\u5e38{}", (Object)exception.toString());
        }
        return true;
    }

    public void addGroup(Channel channel, IConsumer consumer) {
        Group group = new Group(channel, consumer);
        if (this.running) {
            ArrayList<Group> newList = new ArrayList<Group>();
            for (Group before : this.groupList) {
                newList.add(before);
            }
            newList.add(group);
            this.groupList = newList;
        } else {
            this.groupList.add(group);
        }
        this.size = (int)((long)this.size + channel.getSize());
    }

    public int getSize() {
        return this.size;
    }

    public void shutdown() {
        this.running = false;
    }

    private static class Group {
        private Channel channel;
        private IConsumer consumer;

        public Group(Channel channel, IConsumer consumer) {
            this.consumer = consumer;
            this.channel = channel;
        }
    }
}

