/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.ovopark.dc.common.excel.EasyExcelManager;
import com.ovopark.dc.common.excel.EasyExcelStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class EasyExcelListener<T>
extends AnalysisEventListener<T> {
    private List<T> dataList = new ArrayList<T>();
    private Boolean dealFlag;
    private Integer dealNum;
    private Map<String, Object> params;
    private List<T> allData = new ArrayList<T>();

    public EasyExcelListener() {
        this.params = null;
    }

    public EasyExcelListener(Boolean dealFlag, Integer dealNum, Map<String, Object> params) {
        this.dealFlag = dealFlag;
        this.dealNum = dealNum;
        this.params = params;
    }

    public void invoke(T t, AnalysisContext analysisContext) {
        this.dataList.add(t);
        if (this.canDealData() && this.dataList.size() >= this.dealNum) {
            this.dealData(this.dataList, this.params);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        if (this.canDealData()) {
            this.dealData(this.dataList, this.params);
        }
    }

    private boolean canDealData() {
        return Objects.nonNull(this.dealFlag) && this.dealFlag != false && CollectionUtils.isNotEmpty(this.dataList);
    }

    public void dealData(List<T> dataList, Map<String, Object> params) {
        EasyExcelStrategy strategy;
        if (CollectionUtils.isNotEmpty(dataList) && (strategy = EasyExcelManager.getStrategy(dataList.get(0).getClass())) != null) {
            strategy.deal(dataList, params);
            this.allData.addAll(dataList);
            dataList.clear();
        }
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public List<T> getAllData() {
        return this.allData;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }
}

