/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.excel;

import com.ovopark.dc.common.excel.EasyExcelStrategy;
import com.ovopark.dc.common.excel.StorageUpdateExcel;
import com.ovopark.dc.common.utils.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUpdateExcelStrategy
implements EasyExcelStrategy<StorageUpdateExcel> {
    public static final Logger log = LoggerFactory.getLogger(StorageUpdateExcelStrategy.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[+-]?(\\d+(\\.\\d+)?|\\.\\d+)$");

    @Override
    public void deal(List<StorageUpdateExcel> data, Map<String, Object> params) {
        Iterator<StorageUpdateExcel> iterator = data.iterator();
        while (iterator.hasNext()) {
            StorageUpdateExcel excel = iterator.next();
            if (StringUtils.isNotEmpty(excel.getFileName()) && StringUtils.isNotEmpty(excel.getObjectSize())) {
                String objectSize = excel.getObjectSize();
                if (objectSize.contains("GiB")) continue;
                Double flow = 0.0;
                if (objectSize.contains("MiB")) {
                    objectSize = excel.getObjectSize().replace("MiB", "").trim();
                    if (this.isNumber(objectSize)) {
                        flow = Double.valueOf(objectSize);
                    } else {
                        log.error("\u6587\u4ef6\u5927\u5c0f\u8f6c\u6362\u5f02\u5e38\uff1a{}, \u5927\u5c0f\uff1a{} !!!!!!", (Object)excel.getFileName(), (Object)objectSize);
                    }
                } else {
                    objectSize = excel.getObjectSize().trim();
                    if (this.isNumber(objectSize)) {
                        flow = Double.valueOf(objectSize) / 1024.0 / 1024.0;
                    } else {
                        log.error("\u6587\u4ef6\u5927\u5c0f\u8f6c\u6362\u5f02\u5e38\uff1a{}, \u5927\u5c0f\uff1a{} !!!!!!!!", (Object)excel.getFileName(), (Object)objectSize);
                    }
                }
                log.info("\u6587\u4ef6\uff1a{}\uff0c\u5927\u5c0f\uff1a{}", (Object)excel.getFileName(), (Object)flow);
                if (flow < 100.0) {
                    iterator.remove();
                }
                if (!StringUtils.isEmpty(excel.getFileUrl()) || !StringUtils.isNotEmpty(excel.getFileName())) continue;
                String bucketName = excel.getBucketName();
                if (StringUtils.isEmpty(bucketName)) {
                    bucketName = "ovopark";
                }
                excel.setFileUrl("https://" + bucketName + ".oss-cn-hangzhou.aliyuncs.com/" + excel.getFileName());
                continue;
            }
            iterator.remove();
        }
    }

    private boolean isNumber(String input) {
        return input != null && NUMBER_PATTERN.matcher(input).matches();
    }

    @Override
    public Class<StorageUpdateExcel> getKey() {
        return StorageUpdateExcel.class;
    }
}

