/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.http;

import com.ovopark.dc.common.http.ClientHttpConfig;
import com.ovopark.dc.common.http.HttpMethodException;
import com.ovopark.dc.common.http.HttpRequestFactory;
import com.ovopark.dc.common.http.RequestHttpClient;
import com.ovopark.dc.common.http.ResponseHttpClient;
import com.ovopark.dc.common.http.StorageHttpService;
import com.ovopark.dc.common.utils.CommonUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientServiceClient
extends StorageHttpService {
    protected CloseableHttpClient httpClient;
    protected HttpClientConnectionManager connectionManager;
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();

    public HttpClientServiceClient(ClientHttpConfig config) {
        this.connectionManager = this.createConnectionManager(config);
        this.httpClient = this.createHttpClient(this.connectionManager);
    }

    @Override
    protected ResponseHttpClient sendRequestCore(RequestHttpClient request) {
        HttpRequestBase httpRequestBase = httpRequestFactory.createHttpRequest(request);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequestBase);
        }
        catch (IOException e) {
            e.printStackTrace();
            httpRequestBase.abort();
            throw new HttpMethodException("\u8c03\u7528\u51fa\u9519:" + e.getMessage());
        }
        return this.buildResponse(httpResponse, request);
    }

    private ResponseHttpClient buildResponse(CloseableHttpResponse httpResponse, RequestHttpClient request) {
        assert (httpResponse != null);
        ResponseHttpClient response = new ResponseHttpClient();
        response.setUrl(request.getUrl());
        if (httpResponse.getStatusLine() != null) {
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        }
        try {
            if (httpResponse.getEntity() != null) {
                if (response.success()) {
                    response.setContent(httpResponse.getEntity().getContent());
                } else {
                    this.processErrorResponse(httpResponse.getEntity().getContent(), response);
                }
            }
        }
        catch (IOException e) {
            throw new HttpMethodException("\u89e3\u6790response\u5931\u8d25");
        }
        return response;
    }

    private void processErrorResponse(InputStream content, ResponseHttpClient response) {
        byte[] contentBytes = CommonUtil.readStreamAsByte(content);
        response.setContent(new ByteArrayInputStream(contentBytes));
        response.setErrorResponseStr(new String(contentBytes));
    }

    private HttpClientConnectionManager createConnectionManager(ClientHttpConfig config) {
        PoolingHttpClientConnectionManager clientConnectionManager = new PoolingHttpClientConnectionManager();
        clientConnectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        clientConnectionManager.setMaxTotal(config.getMaxConnections());
        clientConnectionManager.setValidateAfterInactivity(config.getValidateAfterInactivity());
        clientConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(config.getSocketTimeout()).setTcpNoDelay(true).build());
        return clientConnectionManager;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).disableContentCompression().disableAutomaticRetries().build();
    }
}

