/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.http;

import com.ovopark.dc.common.http.HttpMethodEnum;
import com.ovopark.dc.common.http.HttpMethodException;
import com.ovopark.dc.common.http.RequestHttpClient;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;

public class HttpRequestFactory {
    public HttpRequestBase createHttpRequest(RequestHttpClient request) {
        HttpGet httpRequestBase;
        if (HttpMethodEnum.GET == request.getHttpMethod()) {
            httpRequestBase = new HttpGet(request.getUrl());
        } else if (HttpMethodEnum.POST == request.getHttpMethod()) {
            HttpPost post = new HttpPost(request.getUrl());
            if (request.getContent() != null) {
                post.setEntity((HttpEntity)new InputStreamEntity(request.getContent()));
            }
            httpRequestBase = post;
        } else {
            throw new HttpMethodException("\u65e0\u6cd5\u5904\u7406\u5f97http\u65b9\u6cd5\u540d\u79f0:" + request.getHttpMethod().toString());
        }
        this.configRequestHeaders(request, (HttpRequestBase)httpRequestBase);
        return httpRequestBase;
    }

    private void configRequestHeaders(RequestHttpClient client, HttpRequestBase httpRequestBase) {
        for (Map.Entry<String, String> entry : client.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequestBase.addHeader(entry.getKey(), entry.getValue());
        }
    }
}

