/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.dc.common.json.StorageJsonException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObject {
    private static final Logger log = LoggerFactory.getLogger(JsonObject.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T toObject(String json, Class<T> type) {
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            log.error("toObject\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898:{}", (Object)e.toString());
            throw new StorageJsonException("\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898");
        }
    }

    public static <T> T toObject(InputStream inputStream, Class<T> type) {
        try {
            return (T)objectMapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            log.error("toObject\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898:{}", (Object)e.toString());
            throw new StorageJsonException("\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898");
        }
    }

    public static String toString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("toString\u5e8f\u5217\u5316\u5f02\u5e38\uff1a{}", (Object)e.toString());
            throw new StorageJsonException("\u5e8f\u5217\u5316String\u51fa\u73b0\u95ee\u9898");
        }
    }

    public static Map<String, Object> toMap(String json) {
        try {
            return (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("toMap\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898:{}", (Object)e.toString());
            throw new StorageJsonException("\u5e8f\u5217\u5316Map\u51fa\u73b0\u95ee\u9898");
        }
    }
}

