/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.time;

import java.util.LinkedHashMap;
import java.util.Map;

public class StopWatch {
    private final String taskName;
    private long startTotalTimeMilli;
    private long endTotalTimeMilli;
    private Map<String, TaskInfo> taskInfoMap;

    public StopWatch(String taskName) {
        this.taskName = taskName;
        this.taskInfoMap = new LinkedHashMap<String, TaskInfo>();
    }

    public void start(String currentTaskName) {
        TaskInfo taskInfo = new TaskInfo(currentTaskName);
        taskInfo.start();
        if (this.startTotalTimeMilli == 0L) {
            this.startTotalTimeMilli = taskInfo.getStartTimeMilli();
        }
        this.taskInfoMap.put(currentTaskName, taskInfo);
    }

    public void end(String currentTaskName) {
        if (!this.taskInfoMap.containsKey(currentTaskName)) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        TaskInfo taskInfo = this.taskInfoMap.get(currentTaskName);
        taskInfo.end();
        this.endTotalTimeMilli = taskInfo.getEndTimeMilli();
    }

    public long getTotalTimeMilli() {
        return this.endTotalTimeMilli - this.startTotalTimeMilli;
    }

    public long getTotalTimeMilliTask(String currentTaskName) {
        if (!this.taskInfoMap.containsKey(currentTaskName)) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        TaskInfo taskInfo = this.taskInfoMap.get(currentTaskName);
        return taskInfo.getEndTimeMilli() - taskInfo.getStartTimeMilli();
    }

    public String prettyPrint() {
        StringBuilder pretty = new StringBuilder();
        long totalTime = this.endTotalTimeMilli - this.startTotalTimeMilli;
        pretty.append(this.taskName);
        pretty.append(" -> time:");
        pretty.append(totalTime);
        pretty.append("ms \n");
        if (this.taskInfoMap.isEmpty()) {
            pretty.append("no task");
        } else {
            int index = 1;
            for (Map.Entry<String, TaskInfo> entry : this.taskInfoMap.entrySet()) {
                if (entry.getValue().getEndTimeMilli() == 0L) continue;
                TaskInfo taskInfo = entry.getValue();
                long time = taskInfo.getEndTimeMilli() - taskInfo.getStartTimeMilli();
                long percent = Math.round(100.0 * (double)time / (double)totalTime);
                pretty.append(index);
                pretty.append(". ");
                pretty.append(taskInfo.getTaskName());
                pretty.append(", time:");
                pretty.append(time);
                pretty.append(", percent:");
                pretty.append(percent);
                pretty.append("% \n");
                ++index;
            }
        }
        return pretty.toString();
    }

    public static final class TaskInfo {
        private final String taskName;
        private long startTimeMilli;
        private long endTimeMilli;

        public TaskInfo(String taskName) {
            this.taskName = taskName;
        }

        public void start() {
            this.startTimeMilli = System.currentTimeMillis();
        }

        public void end() {
            this.endTimeMilli = System.currentTimeMillis();
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getStartTimeMilli() {
            return this.startTimeMilli;
        }

        public long getEndTimeMilli() {
            return this.endTimeMilli;
        }
    }
}

