/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.time;

import com.ovopark.dc.common.time.TimeThread;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TimeService {
    public static final String DATE_FORMAT_DATE_ONLY = "yyyy-MM-dd";
    public static final String DATE_FORMAT_TIME_ONLY = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DATE_PATH_ONLY = "yyyy/MM/dd";

    public static String getDate() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DATE_ONLY);
        format.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        return format.format(TimeThread.currentTimeMillis());
    }

    public static String getTime() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_TIME_ONLY);
        format.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        return format.format(TimeThread.currentTimeMillis());
    }

    public static String getDatePath() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DATE_PATH_ONLY);
        format.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        return format.format(TimeThread.currentTimeMillis());
    }

    public static long timeGapByNow(long time) {
        long now = TimeThread.currentTimeMillis();
        return TimeUnit.MILLISECONDS.toSeconds(now - time);
    }

    public static long timeGapByDeadline(long time) {
        long now = TimeThread.currentTimeMillis();
        long gap = time - now;
        if (gap < 0L) {
            gap = 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(gap);
    }

    public static long getTimeBucket(long timestamp, int value, int gap) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.of("Asia/Shanghai"));
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        long day = dateTime.getDayOfMonth();
        long hour = dateTime.getHour();
        long minute = dateTime.getMinute();
        long second = dateTime.getSecond();
        switch (value) {
            case 1: {
                return (long)year * 10000000000L + (long)(month * 100000000) + day * 1000000L + hour * 10000L + minute * 100L + (second += (long)gap);
            }
            case 2: {
                return (long)(year * 100000000 + month * 1000000) + day * 10000L + hour * 100L + (minute += (long)gap);
            }
            case 3: {
                return (long)(year * 1000000 + month * 10000) + day * 100L + (hour += (long)gap);
            }
            case 4: {
                return (long)(year * 10000 + month * 100) + (day += (long)gap);
            }
        }
        return 0L;
    }

    public static long timeAddHour(long hour, long time) {
        return time + hour * 60L * 60L * 1000L;
    }
}

