/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.utils;

import com.ovopark.dc.common.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

public class CommonUtil {
    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp() || networkInterface.isVirtual()) continue;
                for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
                    if (!(address.getAddress() instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address.getAddress();
                    return inet4Address.getHostAddress();
                }
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String simpleClassName(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        String className = clazz.getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx > -1) {
            return className.substring(lastDotIdx + 1);
        }
        return className;
    }

    public static byte[] readStreamAsByte(InputStream inputStream) {
        if (inputStream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        int len = -1;
        try {
            while ((len = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, len);
            }
            outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static boolean isPic(String type) {
        return "bmp".equals(type = type.toLowerCase()) || "jpeg".equals(type) || "jpg".equals(type) || "png".equals(type);
    }

    public static boolean isNum(String str) {
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static Field getDeclaredField(Class<?> destClass, String name) {
        if (destClass != null) {
            Field[] fields;
            for (Field field : fields = destClass.getDeclaredFields()) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
            return null;
        }
        return null;
    }

    public static String dateFormat(String date) {
        if (StringUtils.isEmpty(date)) {
            return "";
        }
        if (date.length() == 8) {
            return date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
        }
        return date;
    }

    public static <T> List<List<T>> splitList(List<T> list, int len) {
        if (list == null || list.isEmpty() || len < 1) {
            return Collections.emptyList();
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<T> subList = list.subList(i * len, (i + 1) * len > size ? size : len * (i + 1));
            result.add(subList);
        }
        return result;
    }
}

