/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.utils;

import java.util.HashMap;
import java.util.Map;

public class LruCache {
    private int size;
    private int capacity;
    private LruNode head;
    private LruNode tail;
    private Map<Long, LruNode> cache = new HashMap<Long, LruNode>();

    public LruCache(int capacity) {
        this.capacity = capacity;
        this.size = 0;
        this.head = new LruNode();
        this.tail = new LruNode();
        this.head.next = this.tail;
        this.tail.pre = this.head;
    }

    public void clear() {
        this.size = 0;
        this.cache.clear();
        this.head.next = this.tail;
    }

    public int getSize() {
        return this.size;
    }

    public Boolean contain(Long key) {
        LruNode node = this.cache.get(key);
        if (node == null) {
            return false;
        }
        this.moveToHead(node);
        return true;
    }

    private void addHead(LruNode node) {
        node.pre = this.head;
        node.next = this.head.next;
        this.head.next.pre = node;
        this.head.next = node;
    }

    private void removeNode(LruNode node) {
        node.pre.next = node.next;
        node.next.pre = node.pre;
    }

    private void moveToHead(LruNode node) {
        this.removeNode(node);
        this.addHead(node);
    }

    public void put(Long key) {
        LruNode node = this.cache.get(key);
        if (node == null) {
            node = new LruNode(key);
            this.addHead(node);
            this.cache.put(key, node);
            ++this.size;
            if (this.size > this.capacity) {
                LruNode tail = this.removeTail();
                this.cache.remove(tail.key);
                --this.size;
            }
        } else {
            this.moveToHead(node);
        }
    }

    private LruNode removeTail() {
        LruNode tail = this.tail.pre;
        this.removeNode(tail);
        return tail;
    }

    class LruNode {
        private Long key;
        private LruNode next;
        private LruNode pre;

        public LruNode() {
        }

        public LruNode(Long key) {
            this.key = key;
        }

        public Long getKey() {
            return this.key;
        }

        public void setKey(Long key) {
            this.key = key;
        }

        public LruNode getNext() {
            return this.next;
        }

        public void setNext(LruNode next) {
            this.next = next;
        }

        public LruNode getPre() {
            return this.pre;
        }

        public void setPre(LruNode pre) {
            this.pre = pre;
        }
    }
}

