/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.utils;

public class StringUtils {
    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean isNotEmpty(Object str) {
        return !StringUtils.isEmpty(str);
    }

    public static String toCamelCase(String data) {
        if (StringUtils.isEmpty(data)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(data.length());
        boolean upper = false;
        for (int index = 0; index < data.length(); ++index) {
            char ch = data.charAt(index);
            if (ch == '-') {
                upper = true;
                continue;
            }
            if (upper) {
                stringBuilder.append(Character.toUpperCase(ch));
                upper = false;
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    public static boolean isDate(String yearStr, String monthStr, String dateStr) {
        if (StringUtils.isEmpty(yearStr) || StringUtils.isEmpty(monthStr) || StringUtils.isEmpty(dateStr)) {
            return false;
        }
        if (!(StringUtils.isNumeric(yearStr) && StringUtils.isNumeric(monthStr) && StringUtils.isNumeric(dateStr))) {
            return false;
        }
        try {
            int year = Integer.parseInt(yearStr);
            int month = Integer.parseInt(monthStr);
            int date = Integer.parseInt(dateStr);
            if (year < 1 || month < 1 || month > 12 || date < 1 || date > 31) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }
}

