/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.dto;

import com.ovopark.dc.entity.OssUploadResult;

public class FreezeStateDTO {
    private int state;
    private double rate;
    private long completeNum;
    private long unCompleteNum;
    private long sum;
    private String message;

    public static FreezeStateDTO fromOssUploadResult(OssUploadResult result) {
        FreezeStateDTO freezeStateDTO = new FreezeStateDTO();
        freezeStateDTO.setState(result.getStatusCode());
        freezeStateDTO.setCompleteNum(result.getCompleteNum());
        freezeStateDTO.setUnCompleteNum(result.getUnCompleteNum());
        freezeStateDTO.setSum(result.getCompleteNum() + result.getUnCompleteNum());
        if (freezeStateDTO.getSum() != 0L && result.getCompleteNum() != 0L) {
            freezeStateDTO.setRate((double)(result.getCompleteNum() * 100L) / (double)freezeStateDTO.getSum());
        }
        freezeStateDTO.setMessage(result.getErrorResponseAsString());
        return freezeStateDTO;
    }

    public int getState() {
        return this.state;
    }

    public double getRate() {
        return this.rate;
    }

    public long getCompleteNum() {
        return this.completeNum;
    }

    public long getUnCompleteNum() {
        return this.unCompleteNum;
    }

    public long getSum() {
        return this.sum;
    }

    public String getMessage() {
        return this.message;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public void setCompleteNum(long completeNum) {
        this.completeNum = completeNum;
    }

    public void setUnCompleteNum(long unCompleteNum) {
        this.unCompleteNum = unCompleteNum;
    }

    public void setSum(long sum) {
        this.sum = sum;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreezeStateDTO)) {
            return false;
        }
        FreezeStateDTO other = (FreezeStateDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        if (Double.compare(this.getRate(), other.getRate()) != 0) {
            return false;
        }
        if (this.getCompleteNum() != other.getCompleteNum()) {
            return false;
        }
        if (this.getUnCompleteNum() != other.getUnCompleteNum()) {
            return false;
        }
        if (this.getSum() != other.getSum()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FreezeStateDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getState();
        long $rate = Double.doubleToLongBits(this.getRate());
        result = result * 59 + (int)($rate >>> 32 ^ $rate);
        long $completeNum = this.getCompleteNum();
        result = result * 59 + (int)($completeNum >>> 32 ^ $completeNum);
        long $unCompleteNum = this.getUnCompleteNum();
        result = result * 59 + (int)($unCompleteNum >>> 32 ^ $unCompleteNum);
        long $sum = this.getSum();
        result = result * 59 + (int)($sum >>> 32 ^ $sum);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "FreezeStateDTO(state=" + this.getState() + ", rate=" + this.getRate() + ", completeNum=" + this.getCompleteNum() + ", unCompleteNum=" + this.getUnCompleteNum() + ", sum=" + this.getSum() + ", message=" + this.getMessage() + ")";
    }
}

