/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.dto;

import com.ovopark.dc.dto.BankCardDTO;
import com.ovopark.dc.dto.LicenseDTO;
import com.ovopark.dc.dto.OcrIdCardDTO;
import com.ovopark.dc.dto.PermitToHKDTO;
import com.ovopark.dc.entity.OcrRecognizeResult;
import com.ovopark.dc.enums.CredentialsEnum;
import com.ovopark.dc.vo.OcrCredentialResultVO;

public class RecognizeCredentialDTO {
    private OcrIdCardDTO idCard;
    private PermitToHKDTO permitToHK;
    private BankCardDTO bankCard;
    private LicenseDTO license;

    public static RecognizeCredentialDTO fromOcrRecognizeResult(OcrRecognizeResult result, Integer type) {
        RecognizeCredentialDTO recognizeCredential = new RecognizeCredentialDTO();
        if (CredentialsEnum.ID_CARD.getType() == type.intValue()) {
            recognizeCredential.setIdCard(result.getIdCard());
        }
        if (CredentialsEnum.PERMIT_HK.getType() == type.intValue()) {
            recognizeCredential.setPermitToHK(result.getPermitToHK());
        }
        if (CredentialsEnum.BANK_CARD.getType() == type.intValue()) {
            recognizeCredential.setBankCard(result.getBankCard());
        }
        if (CredentialsEnum.LICENSE.getType() == type.intValue()) {
            recognizeCredential.setLicense(result.getLicense());
        }
        return recognizeCredential;
    }

    public OcrCredentialResultVO toOcrRecognizeResult() {
        String issuePlace;
        String idNumber;
        String address;
        String birthDate;
        String ethnicity;
        String nameEn;
        String type;
        OcrCredentialResultVO result = new OcrCredentialResultVO();
        String string = this.idCard != null ? this.idCard.getType() : (this.permitToHK != null ? this.permitToHK.getPermitType() : (this.bankCard != null ? this.bankCard.getCardType() : (type = this.license != null ? this.license.getType() : null)));
        String name = this.idCard != null ? this.idCard.getName() : (this.permitToHK != null ? this.permitToHK.getNameCn() : (this.bankCard != null ? this.bankCard.getBankName() : (this.license != null ? this.license.getName() : null)));
        String string2 = nameEn = this.permitToHK != null ? this.permitToHK.getNameEn() : null;
        String sex = this.idCard != null ? this.idCard.getSex() : (this.permitToHK != null ? this.permitToHK.getSex() : null);
        String string3 = ethnicity = this.idCard != null ? this.idCard.getEthnicity() : null;
        String string4 = this.idCard != null ? this.idCard.getBirthDate() : (birthDate = this.permitToHK != null ? this.permitToHK.getBirthDate() : null);
        String string5 = this.idCard != null ? this.idCard.getAddress() : (address = this.license != null ? this.license.getAddress() : null);
        String string6 = this.idCard != null ? this.idCard.getIdNumber() : (this.permitToHK != null ? this.permitToHK.getPermitNumber() : (this.bankCard != null ? this.bankCard.getCardNumber() : (idNumber = this.license != null ? this.license.getUnifiedSocialCreditCode() : null)));
        String issueAuthority = this.idCard != null ? this.idCard.getIssueAuthority() : (this.permitToHK != null ? this.permitToHK.getIssueAuthority() : null);
        String string7 = issuePlace = this.permitToHK != null ? this.permitToHK.getIssuePlace() : null;
        String validPeriod = this.idCard != null ? this.idCard.getValidPeriod() : (this.permitToHK != null ? this.permitToHK.getValidPeriod() : (this.bankCard != null ? this.bankCard.getValidToDate() : (this.license != null ? this.license.getEndTime() : null)));
        String legalRepresentative = this.license != null ? this.license.getLegalRepresentative() : null;
        String establishDate = this.license != null ? this.license.getStartTime() : null;
        result.setType(type);
        result.setName(name);
        result.setNameEn(nameEn);
        result.setSex(sex);
        result.setEthnicity(ethnicity);
        result.setBirthDate(birthDate);
        result.setAddress(address);
        result.setIdNumber(idNumber);
        result.setIssueAuthority(issueAuthority);
        result.setIssuePlace(issuePlace);
        result.setValidPeriod(validPeriod);
        result.setLegalRepresentative(legalRepresentative);
        result.setEstablishDate(establishDate);
        return result;
    }

    public OcrIdCardDTO getIdCard() {
        return this.idCard;
    }

    public PermitToHKDTO getPermitToHK() {
        return this.permitToHK;
    }

    public BankCardDTO getBankCard() {
        return this.bankCard;
    }

    public LicenseDTO getLicense() {
        return this.license;
    }

    public void setIdCard(OcrIdCardDTO idCard) {
        this.idCard = idCard;
    }

    public void setPermitToHK(PermitToHKDTO permitToHK) {
        this.permitToHK = permitToHK;
    }

    public void setBankCard(BankCardDTO bankCard) {
        this.bankCard = bankCard;
    }

    public void setLicense(LicenseDTO license) {
        this.license = license;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecognizeCredentialDTO)) {
            return false;
        }
        RecognizeCredentialDTO other = (RecognizeCredentialDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OcrIdCardDTO this$idCard = this.getIdCard();
        OcrIdCardDTO other$idCard = other.getIdCard();
        if (this$idCard == null ? other$idCard != null : !((Object)this$idCard).equals(other$idCard)) {
            return false;
        }
        PermitToHKDTO this$permitToHK = this.getPermitToHK();
        PermitToHKDTO other$permitToHK = other.getPermitToHK();
        if (this$permitToHK == null ? other$permitToHK != null : !((Object)this$permitToHK).equals(other$permitToHK)) {
            return false;
        }
        BankCardDTO this$bankCard = this.getBankCard();
        BankCardDTO other$bankCard = other.getBankCard();
        if (this$bankCard == null ? other$bankCard != null : !((Object)this$bankCard).equals(other$bankCard)) {
            return false;
        }
        LicenseDTO this$license = this.getLicense();
        LicenseDTO other$license = other.getLicense();
        return !(this$license == null ? other$license != null : !((Object)this$license).equals(other$license));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecognizeCredentialDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OcrIdCardDTO $idCard = this.getIdCard();
        result = result * 59 + ($idCard == null ? 43 : ((Object)$idCard).hashCode());
        PermitToHKDTO $permitToHK = this.getPermitToHK();
        result = result * 59 + ($permitToHK == null ? 43 : ((Object)$permitToHK).hashCode());
        BankCardDTO $bankCard = this.getBankCard();
        result = result * 59 + ($bankCard == null ? 43 : ((Object)$bankCard).hashCode());
        LicenseDTO $license = this.getLicense();
        result = result * 59 + ($license == null ? 43 : ((Object)$license).hashCode());
        return result;
    }

    public String toString() {
        return "RecognizeCredentialDTO(idCard=" + this.getIdCard() + ", permitToHK=" + this.getPermitToHK() + ", bankCard=" + this.getBankCard() + ", license=" + this.getLicense() + ")";
    }
}

