/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.enums;

import com.ovopark.dc.enums.EnvironmentEnum;
import java.util.ArrayList;
import java.util.List;

public enum BucketEnum {
    TEST_BUCKET(EnvironmentEnum.DEV, "ovopark-oss-dev", 102),
    DEFAULT_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-default", 101),
    AI_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-ai", 103),
    PATROL_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-patrol", 104),
    OA_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-oa", 105),
    MARKET_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-market", 106),
    EXPLORING_STORE_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-exploring-store", 107),
    WAN_JI_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-wanji", 108),
    WORK_SHOP_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-workshop", 109),
    COLLEGE_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-college", 110),
    PASSENGER_FLOW_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-passenger-flow", 110),
    DATA_ASSETS_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-data-assets", 111),
    UNIQUE_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-unique", 112),
    WEB_SDK_BUCKET(EnvironmentEnum.PRO, "ovopark-web-sdk", 113),
    DEVICE_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-device", 114),
    ROBOT_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-robot", 115),
    OVOPARK_BUCKET(EnvironmentEnum.PRO, "ovopark", 100),
    AI_TRAINING_BUCKET(EnvironmentEnum.PRO, "ovopark-oss-ai-training", 116);

    private final EnvironmentEnum environment;
    private final String bucket;
    private final int index;

    private BucketEnum(EnvironmentEnum environment, String bucket, int index) {
        this.environment = environment;
        this.bucket = bucket;
        this.index = index;
    }

    public static boolean containBucketName(String bucketName) {
        for (BucketEnum bucketEnum : BucketEnum.values()) {
            if (!bucketEnum.getBucket().equals(bucketName)) continue;
            return true;
        }
        return false;
    }

    public static List<BucketEnum> getBucketByEnv(EnvironmentEnum environment) {
        ArrayList<BucketEnum> result = new ArrayList<BucketEnum>();
        for (BucketEnum bucketEnum : BucketEnum.values()) {
            if (bucketEnum.environment != environment) continue;
            result.add(bucketEnum);
        }
        return result;
    }

    public EnvironmentEnum getEnvironment() {
        return this.environment;
    }

    public String getBucket() {
        return this.bucket;
    }

    public int getIndex() {
        return this.index;
    }
}

