/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.enums;

import com.ovopark.dc.enums.EnvironmentEnum;
import com.ovopark.dc.enums.RegionEnum;
import com.ovopark.dc.enums.StorageTypeEnum;

public enum CustomerArchiveEnum {
    DASHU_ARCHIVE_LOCAL(EnvironmentEnum.LOCAL, RegionEnum.MAINLAND, "dashu", StorageTypeEnum.aliyun, "dashu-archive", 201),
    DASHU_ARCHIVE_PRO(EnvironmentEnum.PRO, RegionEnum.MAINLAND, "dashu", StorageTypeEnum.aliyun, "dashu-archive", 201),
    DASHU_ARCHIVE_DEV(EnvironmentEnum.DEV, RegionEnum.MAINLAND, "dashu", StorageTypeEnum.aliyun, "dashu-archive", 201),
    OVOPARK_ARCHIVE_LOCAL(EnvironmentEnum.LOCAL, RegionEnum.MAINLAND, "ovopark", StorageTypeEnum.aliyun, "ovopark-archive", 202),
    OVOPARK_ARCHIVE_DEV(EnvironmentEnum.DEV, RegionEnum.MAINLAND, "ovopark", StorageTypeEnum.aliyun, "ovopark-archive", 202),
    OVOPARK_ARCHIVE_PRO(EnvironmentEnum.PRO, RegionEnum.MAINLAND, "ovopark", StorageTypeEnum.aliyun, "ovopark-archive", 202);

    private final EnvironmentEnum environment;
    private final RegionEnum region;
    private final String customer;
    private final StorageTypeEnum storageType;
    private final String bucket;
    private final int index;

    private CustomerArchiveEnum(EnvironmentEnum environment, RegionEnum region, String customer, StorageTypeEnum storageTypeEnum, String bucket, int index) {
        this.environment = environment;
        this.region = region;
        this.customer = customer;
        this.storageType = storageTypeEnum;
        this.bucket = bucket;
        this.index = index;
    }

    public static CustomerArchiveEnum getBucketCodeByCustomer(EnvironmentEnum environment, RegionEnum region, String customer) {
        for (CustomerArchiveEnum bucketEnum : CustomerArchiveEnum.values()) {
            if (!bucketEnum.environment.equals((Object)environment) || !bucketEnum.region.equals((Object)region) || !bucketEnum.customer.equals(customer)) continue;
            return bucketEnum;
        }
        return null;
    }

    public EnvironmentEnum getEnvironment() {
        return this.environment;
    }

    public RegionEnum getRegion() {
        return this.region;
    }

    public String getCustomer() {
        return this.customer;
    }

    public StorageTypeEnum getStorageType() {
        return this.storageType;
    }

    public String getBucket() {
        return this.bucket;
    }

    public int getIndex() {
        return this.index;
    }
}

