/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.enums;

public enum SamplingEnum {
    NONE(0, "", "", 0),
    SECOND(1, "second", "s", 60),
    MINUTE(2, "minute", "m", 60),
    HOUR(3, "hour", "h", 10),
    DAY(4, "day", "d", 2);

    private final int value;
    private final String name;
    private final String code;
    private final int num;

    private SamplingEnum(int value, String name, String code, int num) {
        this.value = value;
        this.name = name;
        this.code = code;
        this.num = num;
    }

    public String getCode() {
        return this.code;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public int getNum() {
        return this.num;
    }

    public static int getValueByCodeDefaultHour(String code) {
        for (SamplingEnum one : SamplingEnum.values()) {
            if (!one.getCode().equals(code)) continue;
            return one.getValue();
        }
        return HOUR.getValue();
    }

    public static int getNumByValue(int value) {
        for (SamplingEnum one : SamplingEnum.values()) {
            if (one.getValue() != value) continue;
            return one.getNum();
        }
        return 0;
    }
}

