/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.enums;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum StorageTypeEnum {
    aliyun("aliyun", 1),
    tencent("tencent", 2),
    ctyun("ctyun", 3),
    minio("minio", 4),
    aws("aws", 5),
    HUAWEI("huawei", 6),
    AZURE("azure", 7),
    QINIU("qiniu", 8);

    private final String key;
    private final Integer value;

    private StorageTypeEnum(String key, Integer value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Integer getValue() {
        return this.value;
    }

    public static Integer getValue(String key) {
        for (StorageTypeEnum e : StorageTypeEnum.values()) {
            if (!e.key.equals(key)) continue;
            return e.value;
        }
        return null;
    }

    public static boolean hasStorageType(int type) {
        for (StorageTypeEnum e : StorageTypeEnum.values()) {
            if (type != e.value) continue;
            return true;
        }
        return false;
    }

    public static Set<Integer> supportStorageType(List<String> storageTypeList) {
        HashSet<Integer> storageType = new HashSet<Integer>();
        for (StorageTypeEnum storageTypeEnum : StorageTypeEnum.values()) {
            if (!storageTypeList.contains(storageTypeEnum.key)) continue;
            storageType.add(storageTypeEnum.value);
        }
        return storageType;
    }

    public static List<String> getStorageType() {
        ArrayList<String> storageType = new ArrayList<String>();
        for (StorageTypeEnum storageTypeEnum : StorageTypeEnum.values()) {
            storageType.add(storageTypeEnum.key);
        }
        return storageType;
    }

    public static String getValue(int value) {
        for (StorageTypeEnum e : StorageTypeEnum.values()) {
            if (!e.value.equals(value)) continue;
            return e.key;
        }
        return null;
    }
}

