/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.result;

import com.ovopark.dc.result.Response;
import java.io.Serializable;

public class ResponseUtil
implements Serializable {
    public static <T> Response<T> success() {
        Response result = new Response();
        result.setCode(200);
        result.setMessage("success");
        result.setIsError(false);
        return result;
    }

    public static <T> Response<T> success(String msg) {
        Response result = new Response();
        result.setCode(200);
        result.setMessage(msg);
        result.setIsError(false);
        return result;
    }

    public static <T> Response<T> success(T data) {
        Response<T> result = new Response<T>();
        result.setCode(200);
        result.setData(data);
        result.setMessage("success");
        result.setIsError(false);
        return result;
    }

    public static <T> Response<T> error() {
        Response result = new Response();
        result.setCode(500);
        result.setMessage("error");
        result.setIsError(true);
        return result;
    }

    public static <T> Response<T> error(String msg) {
        Response result = new Response();
        result.setCode(500);
        result.setMessage(msg);
        result.setIsError(true);
        return result;
    }

    public static <T> Response<T> error(Integer code, String msg) {
        Response result = new Response();
        result.setCode(code);
        result.setMessage(msg);
        result.setData(null);
        result.setIsError(true);
        return result;
    }

    public static Response<String> error(Integer code, String msg, String data) {
        Response<String> result = new Response<String>();
        result.setCode(code);
        result.setMessage(msg);
        result.setData(data);
        result.setIsError(true);
        return result;
    }
}

