/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.service.impl;

import com.ovopark.dc.common.utils.UrlUtils;
import com.ovopark.dc.core.client.OpClient;
import com.ovopark.dc.enums.ArchiveTypeEnum;
import com.ovopark.dc.service.FileArchiveService;
import com.ovopark.dc.vo.FileArchiveVO;
import com.ovopark.dc.vo.FileStateVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileArchiveServiceImpl
implements FileArchiveService {
    @Autowired
    private OpClient opClient;

    @Override
    public FileArchiveVO fileArchiveProcess(String url, String business, String enterprisePath, String date, String customer, Integer recover) {
        url = UrlUtils.urlDecode((String)url);
        String archiveUrl = this.opClient.fileArchive(customer, url, business, date, enterprisePath, "", "", ArchiveTypeEnum.COLD_ARCHIVE.getType(), recover);
        return new FileArchiveVO(archiveUrl);
    }

    @Override
    public FileStateVO fileUnfreezeProcess(String urlPath, int day) {
        urlPath = UrlUtils.urlDecode((String)urlPath);
        return this.opClient.unfreeze(urlPath, day);
    }

    @Override
    public FileStateVO fileUnfreezeState(String urlPath) {
        urlPath = UrlUtils.urlDecode((String)urlPath);
        return this.opClient.unfreezeState(urlPath);
    }
}

