/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.service.impl;

import com.ovopark.dc.common.excel.EasyExcelUtil;
import com.ovopark.dc.common.excel.StorageUpdateExcel;
import com.ovopark.dc.core.client.OpClient;
import com.ovopark.dc.dto.CdnAliyunParamDTO;
import com.ovopark.dc.service.FileManageService;
import com.ovopark.dc.vo.FileListVO;
import com.ovopark.dc.vo.FileRecordSizeFlowVO;
import com.ovopark.dc.vo.FileRecordVO;
import com.ovopark.dc.vo.FileUpdateMetaVO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileManageServiceImpl
implements FileManageService {
    @Autowired
    private OpClient opClient;

    @Override
    public FileListVO getFileManagePath(String businessCode, String path, String storage, String pageSign, Integer size) {
        return this.opClient.getFileListByPath(businessCode, path, storage, pageSign, size);
    }

    @Override
    public boolean deleteDirFile(String businessCode, String path, Integer deleteType, String storage) {
        return this.opClient.deleteDirFile(businessCode, path, deleteType, storage);
    }

    @Override
    public boolean recordFile(FileRecordVO fileRecord) {
        return this.opClient.recordFile(fileRecord);
    }

    @Override
    public FileRecordSizeFlowVO getRecordSummary(String groupId, String businessCode, String storage) {
        return this.opClient.getRecordSummary(groupId, businessCode, storage);
    }

    @Override
    public boolean updateFileMeta(FileUpdateMetaVO fileCopyMeta) {
        if (fileCopyMeta.getExcelFileList() != null && !fileCopyMeta.getExcelFileList().isEmpty()) {
            ArrayList fileUrlList = fileCopyMeta.getFileUrlList();
            if (fileUrlList == null) {
                fileUrlList = new ArrayList();
            }
            for (String fileName : fileCopyMeta.getExcelFileList()) {
                List dataList = EasyExcelUtil.doImportProcess((File)new File(fileName), (Integer)0, null, StorageUpdateExcel.class, null);
                fileUrlList.addAll(dataList.stream().map(StorageUpdateExcel::getFileUrl).collect(Collectors.toList()));
            }
            fileCopyMeta.setFileUrlList(fileUrlList);
        }
        return this.opClient.updateFileMeta(fileCopyMeta.getFileUrlList(), fileCopyMeta.getArchiveType(), fileCopyMeta.isNoCache());
    }

    @Override
    public String cdnAuth(HttpServletRequest request) {
        String httpHost = request.getHeader("http_host");
        String remoteAddr = request.getHeader("remote_addr");
        String requestUri = request.getHeader("request_uri");
        String uri = request.getHeader("uri");
        String userAgent = request.getHeader("http_user_agent");
        String refer = request.getHeader("http_refer");
        String forwardedFor = request.getHeader("http_x_forwarded_for");
        String contentType = request.getHeader("http_content_type");
        String requestMethod = request.getHeader("request_method");
        CdnAliyunParamDTO cdnAliyunParam = new CdnAliyunParamDTO(httpHost, remoteAddr, requestUri, uri, userAgent, refer, forwardedFor, contentType, requestMethod);
        return this.opClient.cdnAuth(cdnAliyunParam);
    }
}

