/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.auth.controller;

import com.ovopark.boot.common.code.support.ApiCodeResult;
import com.ovopark.boot.common.plugin.activerecord.GG;
import com.ovopark.dc.before.des.EncrypDES;
import com.ovopark.dc.before.jedis.JedisPoolUtil;
import com.ovopark.dc.before.jwt.JwtUtils;
import com.ovopark.dc.before.time.TimeUtil;
import com.ovopark.dc.storage.broker.model.bo.OssFileBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import redis.clients.jedis.Jedis;

@Controller
@RequestMapping(value={"/api/dc/storage/auth"})
public class AuthController {
    @Value(value="${dc-storage-broker-server.url}")
    private String storageBrokerServerUrl;
    @Value(value="${dc-storage-broker-server.urlInternal}")
    private String storageBrokerServerUrlInternal;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static final Logger logger = LoggerFactory.getLogger(AuthController.class);

    @RequestMapping(value={"/v1/getExpiredToken"})
    @ResponseBody
    public GG getExpiredToken(@RequestParam(name="globalDuration") Integer globalDuration, @RequestParam(name="globalTimeUnitId") Integer globalTimeUnitId, @RequestParam(name="isInternal", required=false, defaultValue="false") boolean isInternal, @RequestBody List<OssFileBO> ossFileBOS) {
        ArrayList<String> resultLists = new ArrayList<String>();
        logger.info(String.format("\u5904\u7406\u7b7e\u540d\u7684\u56fe\u7247\u6570\u91cf:%d", ossFileBOS.size()));
        String url = this.storageBrokerServerUrl;
        if (isInternal) {
            url = this.storageBrokerServerUrlInternal;
        }
        try {
            for (OssFileBO ossFileBO : ossFileBOS) {
                String token;
                HashMap<String, Object> ossFileMap = new HashMap<String, Object>();
                ossFileMap.put("oldAccessUrl", ossFileBO.getOldAccessUrl());
                ossFileMap.put("storageType", ossFileBO.getStorageType());
                ossFileMap.put("moduleId", ossFileBO.getModuleId());
                ossFileMap.put("path", ossFileBO.getPath());
                int partDuration = ossFileBO.getPartDuration();
                int partTimeUnitId = ossFileBO.getPartTimeUnitId();
                if (partDuration <= 0 || partTimeUnitId <= 0) {
                    ossFileMap.put("duration", globalDuration);
                    ossFileMap.put("timeUnitId", globalTimeUnitId);
                    Date globalExpiredDate = TimeUtil.generateDate((int)globalDuration, (int)globalTimeUnitId);
                    ossFileMap.put("expiredDate", sdf.format(globalExpiredDate));
                    token = JwtUtils.createToken(ossFileMap, (Date)globalExpiredDate);
                } else {
                    ossFileMap.put("duration", partDuration);
                    ossFileMap.put("timeUnitId", partTimeUnitId);
                    Date partExpiredDate = TimeUtil.generateDate((int)partDuration, (int)partTimeUnitId);
                    ossFileMap.put("expiredDate", sdf.format(partExpiredDate));
                    token = JwtUtils.createToken(ossFileMap, (Date)partExpiredDate);
                }
                ossFileMap.put("issuedTime", System.currentTimeMillis());
                resultLists.add(url + token);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return ApiCodeResult.success(resultLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/v1/getExpiredToken/new"})
    @ResponseBody
    public GG getExpiredTokenNew(@RequestParam(name="globalDuration") Integer globalDuration, @RequestParam(name="globalTimeUnitId") Integer globalTimeUnitId, @RequestParam(name="isInternal", required=false, defaultValue="false") boolean isInternal, @RequestBody List<OssFileBO> ossFileBOS) {
        ArrayList<String> resultLists = new ArrayList<String>();
        logger.info(String.format("\u5904\u7406\u7b7e\u540d\u7684\u56fe\u7247\u6570\u91cf:%d", ossFileBOS.size()));
        String url = this.storageBrokerServerUrl;
        if (isInternal) {
            url = this.storageBrokerServerUrlInternal;
        }
        try (Jedis jedis = JedisPoolUtil.getJedis();){
            for (OssFileBO ossFileBO : ossFileBOS) {
                HashMap<String, Object> ossFileMap = new HashMap<String, Object>(5);
                ossFileMap.put("oldAccessUrl", ossFileBO.getOldAccessUrl());
                ossFileMap.put("storageType", ossFileBO.getStorageType());
                ossFileMap.put("moduleId", ossFileBO.getModuleId());
                ossFileMap.put("path", ossFileBO.getPath());
                Integer partDuration = ossFileBO.getPartDuration();
                Integer partTimeUnitId = ossFileBO.getPartTimeUnitId();
                String token = null;
                if (partDuration <= 0 || partTimeUnitId <= 0) {
                    ossFileMap.put("duration", globalDuration);
                    ossFileMap.put("timeUnitId", globalTimeUnitId);
                    Date globalExpiredDate = TimeUtil.generateDate((int)globalDuration, (int)globalTimeUnitId);
                    ossFileMap.put("expiredDate", sdf.format(globalExpiredDate));
                    token = JwtUtils.createToken(ossFileMap, (Date)globalExpiredDate);
                } else {
                    ossFileMap.put("duration", partDuration);
                    ossFileMap.put("timeUnitId", partTimeUnitId);
                    Date partExpiredDate = TimeUtil.generateDate((int)partDuration, (int)partTimeUnitId);
                    ossFileMap.put("expiredDate", sdf.format(partExpiredDate));
                    token = JwtUtils.createToken(ossFileMap, (Date)partExpiredDate);
                }
                ossFileMap.put("issuedTime", System.currentTimeMillis());
                String source = JwtUtils.getRandomString((int)10);
                String key = Objects.requireNonNull(EncrypDES.getInstance()).encrypt(source);
                logger.info("\u4f7f\u7528redis\u6765\u4fdd\u5b58\u6570\u636e");
                if (!jedis.set(key, token).equals("")) {
                    logger.info("\u6570\u636e\u4fdd\u5b58\u5230redis\u6210\u529f");
                    resultLists.add(url + key);
                    continue;
                }
                logger.info("\u6570\u636e\u4fdd\u5b58\u5230redis\u5931\u8d25");
                resultLists.add("");
            }
        }
        return ApiCodeResult.success(resultLists);
    }

    @RequestMapping(value={"/v1/getExpiredToken/test"})
    @ResponseBody
    public GG index() throws Exception {
        String source = JwtUtils.getRandomString((int)10);
        String key = EncrypDES.getInstance().encrypt(source);
        String token = "xxxxxx";
        if (!JedisPoolUtil.getJedis().set(key, token).equals("")) {
            return ApiCodeResult.success((Object)key);
        }
        return ApiCodeResult.error();
    }
}

