/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.accumulator;

import com.ovopark.dc.processor.client.callback.Callback;
import com.ovopark.dc.processor.entity.FutureRecordResult;
import com.ovopark.dc.processor.entity.IncompleteBatch;
import com.ovopark.dc.processor.entity.ProducerBatch;
import com.ovopark.dc.processor.util.CopyWriteMap;
import com.ovopark.dc.storage.broker.cache.CaffeineCacheTool;
import com.ovopark.dc.storage.broker.entity.UploadUrlResult;
import com.ovopark.dc.storage.broker.model.dto.StorageBucketDTO;
import com.ovopark.dc.storage.broker.model.dto.StorageUploadParamsDTO;
import com.ovopark.dc.storage.broker.model.enums.StorageTypeEnum;
import com.ovopark.dc.storage.broker.model.enums.UploadWayEnum;
import com.ovopark.dc.storage.broker.model.exception.CacheFetchException;
import com.ovopark.dc.storage.broker.model.exception.StorageSyncException;
import com.ovopark.dc.storage.broker.singleton.entity.GlobalConfigProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.StringUtils;

public class RecordAccumulator {
    private final ConcurrentMap<StorageBucketDTO, Deque<ProducerBatch>> batchDeque;
    private final AtomicInteger appendRecord = new AtomicInteger(0);
    private final AtomicInteger flushRecord = new AtomicInteger(0);
    private IncompleteBatch incompleteBatch;
    private volatile boolean closed = false;
    private CaffeineCacheTool cacheTool;

    public RecordAccumulator(CaffeineCacheTool cacheTool) {
        this.cacheTool = cacheTool;
        this.batchDeque = new CopyWriteMap<StorageBucketDTO, Deque<ProducerBatch>>();
        this.incompleteBatch = new IncompleteBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public RecordAppendResult append(StorageBucketDTO storageUpload, StorageUploadParamsDTO storageUploadParams, Callback callback) {
        Deque<ProducerBatch> deque;
        block7: {
            RecordAppendResult recordAppendResult;
            this.appendRecord.incrementAndGet();
            try {
                Deque<ProducerBatch> deque2 = deque = this.getOrCreateDeque(storageUpload);
                // MONITORENTER : deque2
                if (this.closed) {
                    throw new StorageSyncException("\u7f13\u51b2\u6c60\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5\u518d\u52a0\u5165");
                }
                RecordAppendResult result = this.doAppend(storageUploadParams, callback, deque);
                if (result == null) break block7;
                recordAppendResult = result;
                // MONITOREXIT : deque2
                this.appendRecord.decrementAndGet();
            }
            catch (Throwable throwable) {
                this.appendRecord.decrementAndGet();
                throw throwable;
            }
            return recordAppendResult;
        }
        ProducerBatch producerBatch = new ProducerBatch(storageUpload);
        FutureRecordResult recordResult = producerBatch.doAppend(storageUploadParams, callback);
        deque.addLast(producerBatch);
        this.incompleteBatch.add(producerBatch);
        RecordAppendResult recordAppendResult = new RecordAppendResult(recordResult, producerBatch.full(), true);
        // MONITOREXIT : deque2
        this.appendRecord.decrementAndGet();
        return recordAppendResult;
    }

    private RecordAppendResult doAppend(StorageUploadParamsDTO storageUploadParams, Callback callback, Deque<ProducerBatch> deque) {
        ProducerBatch producerBatch = deque.peekLast();
        if (producerBatch != null) {
            FutureRecordResult futureRecordResult = producerBatch.doAppend(storageUploadParams, callback);
            if (futureRecordResult == null) {
                producerBatch.close();
            } else {
                return new RecordAppendResult(futureRecordResult, producerBatch.full(), false);
            }
        }
        return null;
    }

    private Deque<ProducerBatch> getOrCreateDeque(StorageBucketDTO storageBucket) {
        ArrayDeque<ProducerBatch> deque = (ArrayDeque<ProducerBatch>)this.batchDeque.get(storageBucket);
        if (deque != null) {
            return deque;
        }
        deque = new ArrayDeque<ProducerBatch>();
        Deque previous = this.batchDeque.putIfAbsent(storageBucket, deque);
        if (previous != null) {
            return previous;
        }
        return deque;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageTypeReadyResult ready() {
        HashSet<Integer> readyStorage = new HashSet<Integer>();
        HashSet<Integer> unknownStorage = new HashSet<Integer>();
        for (Map.Entry entry : this.batchDeque.entrySet()) {
            StorageBucketDTO storageTypeBusiness = (StorageBucketDTO)entry.getKey();
            Deque deque = (Deque)entry.getValue();
            ConcurrentMap<StorageBucketDTO, Deque<ProducerBatch>> concurrentMap = this.batchDeque;
            synchronized (concurrentMap) {
                ProducerBatch producerBatch = (ProducerBatch)deque.peekFirst();
                if (StorageTypeEnum.hasStorageType((int)storageTypeBusiness.getStorageType())) {
                    if (producerBatch != null && producerBatch.recordCount() > 0) {
                        readyStorage.add(storageTypeBusiness.getStorageType());
                    }
                } else {
                    unknownStorage.add(storageTypeBusiness.getStorageType());
                }
            }
        }
        return new StorageTypeReadyResult(readyStorage, unknownStorage);
    }

    public Map<Integer, List<ProducerBatch>> drain(Set<Integer> readyStorage, long maxRequestSize) {
        if (readyStorage.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<ProducerBatch>> result = new HashMap<Integer, List<ProducerBatch>>();
        for (int storage : readyStorage) {
            List<ProducerBatch> producerBatchList = this.drainBatchForStorage(storage);
            result.put(storage, producerBatchList);
        }
        return result;
    }

    private List<ProducerBatch> drainBatchForStorage(int storage, long maxRequestSize) {
        ArrayList<ProducerBatch> ready = new ArrayList<ProducerBatch>();
        List uploadList = UploadWayEnum.getCodeByStorage((int)storage);
        long currentSize = 0L;
        for (String way : uploadList) {
            StorageBucketDTO storageUpload = new StorageBucketDTO(storage, way);
            Deque deque = (Deque)this.batchDeque.get(storageUpload);
            while (!deque.isEmpty() && currentSize < maxRequestSize) {
                ProducerBatch producerBatch = (ProducerBatch)deque.pollFirst();
                ready.add((ProducerBatch)deque.pollFirst());
                currentSize += producerBatch.size();
            }
        }
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProducerBatch> drainBatchForStorage(int storage) {
        List bucketList = GlobalConfigProperties.getInstance().getBucket();
        ArrayList<ProducerBatch> ready = new ArrayList<ProducerBatch>();
        if (bucketList == null) {
            return ready;
        }
        for (String bucket : bucketList) {
            StorageBucketDTO storageUpload = new StorageBucketDTO(storage, bucket);
            Deque deque = (Deque)this.batchDeque.get(storageUpload);
            ConcurrentMap<StorageBucketDTO, Deque<ProducerBatch>> concurrentMap = this.batchDeque;
            synchronized (concurrentMap) {
                if (deque != null && !deque.isEmpty()) {
                    ready.add((ProducerBatch)deque.pollFirst());
                }
            }
        }
        return ready;
    }

    public void remove(ProducerBatch batch) {
        this.incompleteBatch.remove(batch);
    }

    public void putProgress(String uploadId, List<Future<UploadUrlResult>> result) {
        if (!StringUtils.isEmpty((Object)uploadId) && !this.cacheTool.containsKey(uploadId) && result.size() > 0) {
            this.cacheTool.put(uploadId, result);
        }
    }

    public List<Future<UploadUrlResult>> getProgress(String uploadId) {
        if (!StringUtils.isEmpty((Object)uploadId) && this.cacheTool.containsKey(uploadId)) {
            return this.cacheTool.get(uploadId);
        }
        throw new CacheFetchException("\u8be5\u4e0a\u4f20id" + uploadId + "\u5df2\u7ecf\u88ab\u6e05\u9664");
    }

    public static final class StorageTypeReadyResult {
        public final Set<Integer> readyStorage;
        public final Set<Integer> unknownStorage;

        public StorageTypeReadyResult(Set<Integer> readyStorage, Set<Integer> unknownStorage) {
            this.readyStorage = readyStorage;
            this.unknownStorage = unknownStorage;
        }
    }

    public static final class RecordAppendResult {
        public final FutureRecordResult futureRecordResult;
        public final boolean full;
        public final boolean newBatch;

        public RecordAppendResult(FutureRecordResult futureRecordResult, boolean full, boolean newBatch) {
            this.futureRecordResult = futureRecordResult;
            this.full = full;
            this.newBatch = newBatch;
        }
    }
}

