/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.client;

import com.ovopark.dc.processor.client.StorageOssClient;
import com.ovopark.dc.processor.client.callback.ResponseHandler;
import com.ovopark.dc.processor.client.selector.Selectable;
import com.ovopark.dc.processor.client.selector.Selector;
import com.ovopark.dc.processor.entity.FlightRequest;
import com.ovopark.dc.processor.entity.StorageTypeConnectionState;
import com.ovopark.dc.processor.entity.request.AbstractRequest;
import com.ovopark.dc.processor.entity.request.AbstractResponse;
import com.ovopark.dc.processor.entity.request.ClientRequest;
import com.ovopark.dc.processor.entity.request.ClientResponse;
import com.ovopark.dc.processor.send.Send;
import com.ovopark.dc.storage.broker.common.thread.DefaultNamedThreadFactory;
import com.ovopark.dc.storage.broker.model.enums.ErrorEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageOssSyncClient
implements StorageOssClient {
    private static final Logger log = LoggerFactory.getLogger(StorageOssSyncClient.class);
    private final Selectable selector;
    private final StorageTypeConnectionState connectionStates;
    private final FlightRequest flightRequest;
    private final List<ClientResponse> abort = new ArrayList<ClientResponse>();
    private final ThreadPoolExecutor executor;

    public StorageOssSyncClient(StorageTypeConnectionState connectionStates) {
        this.selector = new Selector();
        this.connectionStates = connectionStates;
        this.flightRequest = new FlightRequest(100);
        int num = Runtime.getRuntime().availableProcessors() * 2;
        this.executor = new ThreadPoolExecutor(num, num, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5000), (ThreadFactory)new DefaultNamedThreadFactory("upload-client"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void send(ClientRequest clientRequest) {
        if (!this.canSendRequest(clientRequest.getStorage())) {
            log.error("\u65e0\u6cd5\u53d1\u9001\u8bf7\u6c42\u7ed9 {}", (Object)clientRequest.getStorage());
            ClientResponse clientResponse = new ClientResponse(clientRequest.getResponseHandler(), clientRequest.getStorage(), true, null, false);
            this.abort.add(clientResponse);
        }
        this.doSend(clientRequest);
    }

    private void doSend(ClientRequest clientRequest) {
        Object request = clientRequest.getBuilder().build();
        Send send = ((AbstractRequest)request).createSend(this.executor);
        FlightRequest.FlightOneRequest flightOneRequest = new FlightRequest.FlightOneRequest(clientRequest.getStorage(), clientRequest.getResponseHandler(), (AbstractRequest)clientRequest.getBuilder().build(), send, true);
        this.flightRequest.add(flightOneRequest);
        this.selector.send(send);
    }

    private boolean canSendRequest(Integer storage) {
        return this.connectionStates.isConnected(storage) && this.flightRequest.sendMore(storage);
    }

    @Override
    public void flush() {
        this.selector.flush();
    }

    @Override
    public boolean ready(int storage) {
        if (this.isReadyStorage(storage)) {
            return true;
        }
        if (this.connectionStates.canConnect(storage)) {
            this.initConnectionStorage(storage);
            return true;
        }
        return false;
    }

    private void initConnectionStorage(int storage) {
        this.connectionStates.connecting(storage);
    }

    private boolean isReadyStorage(int storage) {
        return this.canSendRequest(storage);
    }

    @Override
    public ClientRequest newClientRequest(int storageType, AbstractRequest.Builder<?> builder, ResponseHandler responseHandler) {
        return new ClientRequest(storageType, responseHandler, builder);
    }

    @Override
    public void poll(long pollTimeout) {
        ArrayList<ClientResponse> responses;
        if (!this.abort.isEmpty()) {
            responses = new ArrayList<ClientResponse>();
            this.handleAbortSends(responses);
            this.handleCompleteCallback(responses);
        }
        this.selector.poll(pollTimeout);
        responses = new ArrayList();
        this.handleSending(responses);
        this.handleCompletedSend(responses);
        this.handleDisconnection(responses);
        this.handleCompleteCallback(responses);
    }

    private void handleSending(List<ClientResponse> responses) {
        for (Send send : this.selector.sending()) {
            FlightRequest.FlightOneRequest flightOneRequest = this.flightRequest.getFlightOneRequest(send);
            AbstractResponse response = AbstractResponse.parseResponse(flightOneRequest.request().key(), send.result(), ErrorEnum.NONE);
            if (!flightOneRequest.uploadRequest()) continue;
            responses.add(flightOneRequest.sending(response));
        }
    }

    private void handleAbortSends(List<ClientResponse> responses) {
        responses.addAll(this.abort);
        this.abort.clear();
    }

    private void handleCompletedSend(List<ClientResponse> responses) {
        Iterator<Send> iterator = this.selector.completedSend().iterator();
        while (iterator.hasNext()) {
            Send send = iterator.next();
            this.doHandleResponse(responses, ErrorEnum.NONE, send);
            iterator.remove();
        }
    }

    private void handleDisconnection(List<ClientResponse> responses) {
        Iterator<Send> iterator = this.selector.failSend().iterator();
        while (iterator.hasNext()) {
            Send send = iterator.next();
            this.doHandleResponse(responses, ErrorEnum.FAIL_SEND, send);
            iterator.remove();
        }
    }

    private void doHandleResponse(List<ClientResponse> responses, ErrorEnum error, Send send) {
        FlightRequest.FlightOneRequest flightOneRequest = this.flightRequest.completeNext(send);
        AbstractResponse response = AbstractResponse.parseResponse(flightOneRequest.request().key(), send.result(), error);
        if (flightOneRequest.uploadRequest()) {
            responses.add(flightOneRequest.completed(response));
        }
    }

    private void handleCompleteCallback(List<ClientResponse> responses) {
        for (ClientResponse response : responses) {
            response.callback();
        }
    }
}

