/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.client.selector;

import com.ovopark.dc.processor.client.selector.Selectable;
import com.ovopark.dc.processor.send.Send;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Selector
implements Selectable {
    private List<Send> completedSend = new ArrayList<Send>();
    private List<Send> prepareSend;
    private List<Send> sending = new ArrayList<Send>();
    private List<Send> failSend = new ArrayList<Send>();

    public Selector() {
        this.prepareSend = new ArrayList<Send>();
    }

    @Override
    public void flush() {
    }

    @Override
    public void send(Send send) {
        this.prepareSend.add(send);
    }

    @Override
    public void poll(long pollTimeout) {
        if (this.prepareSend.isEmpty() && this.sending.isEmpty()) {
            try {
                Thread.sleep(pollTimeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (Send send : this.prepareSend) {
            if (send.completed()) continue;
            this.attemptSend(send);
        }
        this.prepareSend.clear();
        this.finishSending();
    }

    private void finishSending() {
        if (this.sending.isEmpty()) {
            return;
        }
        Iterator<Send> iterator = this.sending.iterator();
        while (iterator.hasNext()) {
            Send send = iterator.next();
            if (!send.receiveResult()) continue;
            if (send.uploadSuccess()) {
                this.completedSend.add(send);
            } else {
                this.failSend.add(send);
            }
            iterator.remove();
        }
    }

    @Override
    public List<Send> completedSend() {
        return this.completedSend;
    }

    @Override
    public List<Send> sending() {
        return this.sending;
    }

    @Override
    public List<Send> failSend() {
        return this.failSend;
    }

    private void attemptSend(Send send) {
        send.upload();
        if (send.receiveResult()) {
            if (send.uploadSuccess()) {
                this.completedSend.add(send);
            } else {
                this.failSend.add(send);
            }
        } else {
            this.sending.add(send);
        }
    }
}

