/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.entity;

import com.ovopark.dc.storage.broker.model.dto.StorageUploadParamsDTO;
import com.ovopark.dc.storage.broker.model.exception.StorageSyncException;
import java.util.ArrayList;
import java.util.List;

public class FileRecordBuilder {
    private List<StorageUploadParamsDTO> record = new ArrayList<StorageUploadParamsDTO>(this.listSize);
    private final long maxSize;
    private long residueSize = this.maxSize = 102400L;
    private int listSize = 20;
    private boolean close = false;
    private long realSize = 0L;

    public List<StorageUploadParamsDTO> records() {
        return this.record;
    }

    public boolean hasSpace(StorageUploadParamsDTO storageUploadParams) {
        if (this.isFull()) {
            return false;
        }
        return !((double)this.residueSize < storageUploadParams.getFileSize()) || this.record.size() <= 0;
    }

    public boolean isFull() {
        return this.record.size() >= this.listSize || this.residueSize <= 0L;
    }

    public void append(StorageUploadParamsDTO storageUploadParams) {
        this.ensureOpen();
        this.record.add(storageUploadParams);
        this.residueSize = (long)((double)this.residueSize - storageUploadParams.getFileSize());
        this.realSize = this.maxSize - this.residueSize;
    }

    public long realSize() {
        return this.realSize;
    }

    private void ensureOpen() {
        if (this.close) {
            throw new StorageSyncException("\u5f53\u524d\u7a7a\u95f4\u5df2\u7ecf\u5173\u95ed\u4e86");
        }
    }

    public void close() {
        this.close = true;
    }
}

