/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.entity;

import com.ovopark.dc.processor.client.callback.ResponseHandler;
import com.ovopark.dc.processor.entity.request.AbstractRequest;
import com.ovopark.dc.processor.entity.request.AbstractResponse;
import com.ovopark.dc.processor.entity.request.ClientResponse;
import com.ovopark.dc.processor.send.Send;
import com.ovopark.dc.storage.broker.model.exception.StorageSyncException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class FlightRequest {
    private final int maxInFlightRequest;
    private final Map<Integer, Map<Send, FlightOneRequest>> requests;
    private final AtomicInteger count = new AtomicInteger(0);

    public FlightRequest(int maxInFlightRequest) {
        this.maxInFlightRequest = maxInFlightRequest;
        this.requests = new HashMap<Integer, Map<Send, FlightOneRequest>>();
    }

    public boolean sendMore(int storage) {
        Map<Send, FlightOneRequest> map = this.requests.get(storage);
        return map == null || map.isEmpty() || map.size() < this.maxInFlightRequest;
    }

    public void add(FlightOneRequest flightOneRequest) {
        Map map = this.requests.computeIfAbsent(flightOneRequest.storage, k -> new HashMap());
        map.put(flightOneRequest.send, flightOneRequest);
        this.count.incrementAndGet();
    }

    public FlightOneRequest completeNext(Send send) {
        Map<Send, FlightOneRequest> map = this.requestQueue(send);
        FlightOneRequest request = map.get(send);
        map.remove(send);
        this.count.decrementAndGet();
        return request;
    }

    public FlightOneRequest getFlightOneRequest(Send send) {
        Map<Send, FlightOneRequest> map = this.requestQueue(send);
        return map.get(send);
    }

    private Map<Send, FlightOneRequest> requestQueue(Send send) {
        Map<Send, FlightOneRequest> map = this.requests.get(send.storage());
        if (map == null || map.isEmpty() || !map.containsKey(send)) {
            throw new StorageSyncException("\u65e0\u6cd5\u83b7\u53d6\u5230flightOneRequest");
        }
        return map;
    }

    public static class FlightOneRequest {
        private final Integer storage;
        private final ResponseHandler callback;
        private final AbstractRequest request;
        private final Send send;
        private final boolean uploadRequest;

        public FlightOneRequest(Integer storage, ResponseHandler callback, AbstractRequest request, Send send, boolean uploadRequest) {
            this.send = send;
            this.storage = storage;
            this.callback = callback;
            this.request = request;
            this.uploadRequest = uploadRequest;
        }

        public ClientResponse completed(AbstractResponse response) {
            return new ClientResponse(this.callback, this.storage, false, response, false);
        }

        public ClientResponse sending(AbstractResponse response) {
            return new ClientResponse(this.callback, this.storage, false, response, true);
        }

        public AbstractRequest request() {
            return this.request;
        }

        public boolean uploadRequest() {
            return this.uploadRequest;
        }
    }
}

