/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.entity;

import com.ovopark.dc.processor.entity.ProducerRequestResult;
import com.ovopark.dc.storage.broker.entity.UploadUrlResult;
import com.ovopark.dc.storage.broker.model.dto.UploadProgressDTO;
import com.ovopark.dc.storage.broker.model.enums.UploadStateEnum;
import com.ovopark.dc.storage.broker.model.result.OssUploadResult;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tomcat.jni.Time;

public class FutureRecordResult
implements Future<UploadUrlResult> {
    private final ProducerRequestResult requestResult;
    private UploadUrlResult result;
    private boolean finish;
    private int percent;

    public FutureRecordResult(ProducerRequestResult requestResult) {
        this.requestResult = requestResult;
        this.finish = false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.finish;
    }

    @Override
    public UploadUrlResult get() throws InterruptedException, ExecutionException {
        this.requestResult.await();
        return this.getResultOrValue();
    }

    @Override
    public UploadUrlResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (timeout > 0L) {
            long unitMillis = unit.toMillis(timeout);
            Time.sleep((long)unitMillis);
        }
        if (this.finish) {
            return this.getResultOrValue();
        }
        UploadUrlResult uploadUrlResult = new UploadUrlResult();
        uploadUrlResult.setUploadState(UploadStateEnum.UPLOADING.getCode());
        uploadUrlResult.setMessage(UploadStateEnum.UPLOADING.getMessage());
        uploadUrlResult.setPercent(this.percent);
        return uploadUrlResult;
    }

    private UploadUrlResult getResultOrValue() throws ExecutionException {
        if (this.requestResult.error() == null) {
            return this.value();
        }
        return this.exceptionResult();
    }

    private UploadUrlResult exceptionResult() {
        if (this.result == null) {
            this.result = new UploadUrlResult();
        }
        this.result.setUploadState(UploadStateEnum.FAIL.getCode());
        return this.result;
    }

    public UploadUrlResult value(OssUploadResult ossUploadResult) {
        this.finish = true;
        this.result = ossUploadResult.uploadResult();
        if (ossUploadResult.getHandleThrowable() == null && ossUploadResult.getThrowable() == null) {
            this.result.setPercent(100);
            this.result.setUploadState(UploadStateEnum.SUCCESS.getCode());
            this.result.setMessage(UploadStateEnum.SUCCESS.getMessage());
        } else {
            this.result.setPercent(0);
            this.result.setUploadState(UploadStateEnum.FAIL.getCode());
            StringBuilder failMessage = new StringBuilder(UploadStateEnum.FAIL.getMessage());
            if (ossUploadResult.getThrowable() != null) {
                failMessage.append("\u539f\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
            }
            if (ossUploadResult.getHandleThrowable() != null) {
                failMessage.append("\u56fe\u7247\u5904\u7406\u5931\u8d25,\u8bf7\u68c0\u67e5\u5904\u7406\u53c2\u6570");
            }
            this.result.setMessage(failMessage.toString());
        }
        return this.result;
    }

    public UploadUrlResult value() {
        return this.result;
    }

    public void progress(UploadProgressDTO uploadProgress) {
        this.percent = uploadProgress.percent();
    }
}

