/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.entity;

import com.ovopark.dc.processor.client.callback.Callback;
import com.ovopark.dc.processor.entity.FileRecordBuilder;
import com.ovopark.dc.processor.entity.FutureRecordResult;
import com.ovopark.dc.processor.entity.ProducerRequestResult;
import com.ovopark.dc.storage.broker.entity.UploadUrlResult;
import com.ovopark.dc.storage.broker.model.dto.StorageBucketDTO;
import com.ovopark.dc.storage.broker.model.dto.StorageUploadParamsDTO;
import com.ovopark.dc.storage.broker.model.dto.UploadProgressDTO;
import com.ovopark.dc.storage.broker.model.result.OssUploadBatchResult;
import com.ovopark.dc.storage.broker.model.result.OssUploadResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerBatch {
    private static final Logger log = LoggerFactory.getLogger(ProducerBatch.class);
    private final StorageBucketDTO storageBucket;
    private final List<Thunk> thunks;
    private final ProducerRequestResult requestResult;
    private FileRecordBuilder fileRecordBuilder;
    private int recordCount;
    private AtomicReference<FinalState> finalState = new AtomicReference<Object>(null);

    public ProducerBatch(StorageBucketDTO storageBucket) {
        this.thunks = new ArrayList<Thunk>();
        this.storageBucket = storageBucket;
        this.requestResult = new ProducerRequestResult(storageBucket);
        this.fileRecordBuilder = new FileRecordBuilder();
    }

    public StorageBucketDTO storageTypeBusiness() {
        return this.storageBucket;
    }

    public long size() {
        return this.fileRecordBuilder.realSize();
    }

    public FutureRecordResult doAppend(StorageUploadParamsDTO storageUploadParams, Callback callback) {
        if (!this.fileRecordBuilder.hasSpace(storageUploadParams)) {
            return null;
        }
        this.fileRecordBuilder.append(storageUploadParams);
        FutureRecordResult futureRecordResult = new FutureRecordResult(this.requestResult);
        this.thunks.add(new Thunk(callback, futureRecordResult, storageUploadParams.getFileStoragePath()));
        ++this.recordCount;
        return futureRecordResult;
    }

    public boolean done(OssUploadBatchResult result, RuntimeException exception) {
        FinalState state;
        FinalState finalState = state = exception == null ? FinalState.SUCCESS : FinalState.FAILED;
        if (state != FinalState.SUCCESS) {
            log.error("{}\u53d1\u9001\u5931\u8d25\u4e86", (Object)this.storageBucket);
        }
        if (this.finalState.compareAndSet(null, state)) {
            try {
                this.finishProduceBatch(result, exception);
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("{}\u83b7\u53d6\u6700\u7ec8\u7684\u7ed3\u679c\u5931\u8d25", (Object)this.storageBucket);
                return false;
            }
            return true;
        }
        return false;
    }

    public void uploadRate(OssUploadBatchResult result) {
        Map pathUploadPercent = result.getPathUploadPercent();
        for (Thunk thunk : this.thunks) {
            if (pathUploadPercent == null || !pathUploadPercent.containsKey(thunk.key)) continue;
            UploadProgressDTO uploadProgress = (UploadProgressDTO)pathUploadPercent.get(thunk.key);
            thunk.result.progress(uploadProgress);
        }
    }

    private void finishProduceBatch(OssUploadBatchResult result, RuntimeException exception) throws ExecutionException, InterruptedException {
        this.requestResult.set(exception);
        Map pathUploadResult = result.getPathUploadResult();
        for (Thunk thunk : this.thunks) {
            if (pathUploadResult == null || !pathUploadResult.containsKey(thunk.key)) continue;
            OssUploadResult ossUploadResult = (OssUploadResult)((Future)pathUploadResult.get(thunk.key)).get();
            UploadUrlResult uploadResult = thunk.result.value(ossUploadResult);
            if (thunk.callback == null) continue;
            thunk.callback.complete(exception, uploadResult);
        }
        this.requestResult.done();
    }

    public FileRecordBuilder fileRecordBuilder() {
        return this.fileRecordBuilder;
    }

    public int recordCount() {
        return this.recordCount;
    }

    public boolean full() {
        return this.fileRecordBuilder.isFull();
    }

    public void close() {
        this.fileRecordBuilder.close();
    }

    private static class Thunk {
        final Callback callback;
        final FutureRecordResult result;
        final String key;

        public Thunk(Callback callback, FutureRecordResult result, String key) {
            this.callback = callback;
            this.result = result;
            this.key = key;
        }
    }

    public static enum FinalState {
        FAILED,
        SUCCESS,
        ABORTED;

    }
}

