/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.entity.request;

import com.ovopark.dc.processor.entity.FileRecordBuilder;
import com.ovopark.dc.processor.entity.request.AbstractRequest;
import com.ovopark.dc.processor.send.AliyunUploadSend;
import com.ovopark.dc.processor.send.Send;
import com.ovopark.dc.storage.broker.client.upload.AbstractUploadClient;
import com.ovopark.dc.storage.broker.model.dto.StorageBucketDTO;
import com.ovopark.dc.storage.broker.model.enums.ApiKeys;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public class AliyunUploadRequest
extends AbstractRequest {
    private final Map<StorageBucketDTO, FileRecordBuilder> record;
    private final Map<StorageBucketDTO, Integer> storageMap;
    private AbstractUploadClient abstractUploadClient;

    public AliyunUploadRequest(Map<StorageBucketDTO, FileRecordBuilder> record, AbstractUploadClient abstractUploadClient) {
        super(ApiKeys.MIN_FILE_UPLOAD_PRODUCER);
        this.record = record;
        this.storageMap = new HashMap<StorageBucketDTO, Integer>();
        for (StorageBucketDTO storageTypeBusiness : this.record.keySet()) {
            if (this.storageMap.containsKey(storageTypeBusiness)) continue;
            this.storageMap.put(storageTypeBusiness, storageTypeBusiness.getStorageType());
        }
        this.abstractUploadClient = abstractUploadClient;
    }

    @Override
    public Send createSend() {
        return this.createSend(null);
    }

    @Override
    public Send createSend(ThreadPoolExecutor executor) {
        return new AliyunUploadSend(this.record, executor, this.abstractUploadClient);
    }

    public static class Builder
    extends AbstractRequest.Builder<AliyunUploadRequest> {
        private final Map<StorageBucketDTO, FileRecordBuilder> record;
        private AbstractUploadClient abstractUploadClient;

        public Builder(Map<StorageBucketDTO, FileRecordBuilder> record, AbstractUploadClient abstractUploadClient) {
            super(ApiKeys.MIN_FILE_UPLOAD_PRODUCER);
            this.record = record;
            this.abstractUploadClient = abstractUploadClient;
        }

        @Override
        public AliyunUploadRequest build() {
            return new AliyunUploadRequest(this.record, this.abstractUploadClient);
        }
    }
}

