/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.interceptor;

import com.ovopark.dc.processor.interceptor.ProducerInterceptor;
import com.ovopark.dc.storage.broker.entity.UploadUrlResult;
import com.ovopark.dc.storage.broker.model.dto.StorageUploadParamsDTO;
import java.util.ArrayList;
import java.util.List;

public class ProducerInterceptorManage {
    private List<ProducerInterceptor> producerInterceptor;

    public ProducerInterceptorManage(List<ProducerInterceptor> producerInterceptor) {
        this.producerInterceptor = producerInterceptor;
    }

    public ProducerInterceptorManage() {
        this.producerInterceptor = new ArrayList<ProducerInterceptor>();
    }

    public void register(ProducerInterceptor interceptor) {
        this.producerInterceptor.add(interceptor);
    }

    public StorageUploadParamsDTO process(StorageUploadParamsDTO storageUploadParams) {
        StorageUploadParamsDTO result = storageUploadParams;
        for (ProducerInterceptor interceptor : this.producerInterceptor) {
            result = interceptor.process(storageUploadParams);
        }
        return result;
    }

    public void ackResponse(UploadUrlResult uploadResult, Exception exception, StorageUploadParamsDTO storageUploadParams) {
        for (int index = this.producerInterceptor.size() - 1; index >= 0; --index) {
            this.producerInterceptor.get(index).ackResponse(uploadResult, exception, storageUploadParams);
        }
    }
}

