/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.producer;

import com.ovopark.dc.processor.accumulator.RecordAccumulator;
import com.ovopark.dc.processor.client.callback.Callback;
import com.ovopark.dc.processor.entity.StorageTypeConnectionState;
import com.ovopark.dc.processor.interceptor.ProducerInterceptorManage;
import com.ovopark.dc.processor.interceptor.impl.ProducerDeviceInterceptor;
import com.ovopark.dc.processor.producer.Producer;
import com.ovopark.dc.processor.sender.Sender;
import com.ovopark.dc.processor.thread.UploadThread;
import com.ovopark.dc.storage.broker.cache.CaffeineCacheTool;
import com.ovopark.dc.storage.broker.client.upload.AliyunUploadClient;
import com.ovopark.dc.storage.broker.entity.UploadUrlResult;
import com.ovopark.dc.storage.broker.model.dto.StorageBucketDTO;
import com.ovopark.dc.storage.broker.model.dto.StorageUploadParamsDTO;
import com.ovopark.dc.storage.broker.model.enums.StorageTypeBusinessStatusEnum;
import com.ovopark.dc.storage.broker.model.exception.StorageSyncException;
import com.ovopark.dc.storage.broker.singleton.entity.StorageOssMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UploadProducer
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(UploadProducer.class);
    public static final String PRODUCER_THREAD_NAME = "upload-producer-thread";
    private final RecordAccumulator recordAccumulator;
    private final Thread sendThread;
    private final Sender sender;
    private ProducerInterceptorManage interceptorManage;
    private StorageOssMetaData metaData;
    private final StorageTypeConnectionState connectionStates;
    private AliyunUploadClient aliyunUploadClient;

    public UploadProducer(CaffeineCacheTool cacheTool, AliyunUploadClient aliyunUploadClient) {
        this.recordAccumulator = new RecordAccumulator(cacheTool);
        this.interceptorManage = new ProducerInterceptorManage();
        this.interceptorManage.register(new ProducerDeviceInterceptor());
        this.metaData = StorageOssMetaData.getInstance();
        this.connectionStates = new StorageTypeConnectionState();
        this.sender = new Sender(this.recordAccumulator, this.connectionStates, aliyunUploadClient);
        this.sendThread = new UploadThread(PRODUCER_THREAD_NAME, (Runnable)this.sender, true);
        this.sendThread.start();
    }

    @Override
    public Future<UploadUrlResult> send(StorageUploadParamsDTO storageUploadParams) {
        storageUploadParams = this.interceptorManage.process(storageUploadParams);
        try {
            return this.doSend(storageUploadParams);
        }
        catch (Exception e) {
            log.error("{}\u53d1\u9001\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)storageUploadParams.getFileStoragePath(), (Object)e.getMessage());
            throw new StorageSyncException(e.getMessage());
        }
    }

    @Override
    public List<Future<UploadUrlResult>> send(List<StorageUploadParamsDTO> storageUploadParams) {
        return this.send(storageUploadParams, null);
    }

    @Override
    public List<Future<UploadUrlResult>> send(List<StorageUploadParamsDTO> storageUploadParams, String uploadId) {
        ArrayList<Future<UploadUrlResult>> result = new ArrayList<Future<UploadUrlResult>>();
        for (StorageUploadParamsDTO storageUploadParamsDTO : storageUploadParams) {
            Future<UploadUrlResult> resultFuture = this.send(storageUploadParamsDTO);
            result.add(resultFuture);
        }
        this.recordAccumulator.putProgress(uploadId, result);
        return result;
    }

    @Override
    public List<Future<UploadUrlResult>> getProgress(String uploadId) {
        return this.recordAccumulator.getProgress(uploadId);
    }

    private Future<UploadUrlResult> doSend(StorageUploadParamsDTO storageUploadParams) {
        StorageBucketDTO storageBucket = new StorageBucketDTO();
        StorageOssBusiness storageOssBusiness = this.waitMetaData(storageUploadParams.getStorageType(), storageUploadParams.getBusinessCode());
        if (StorageTypeBusinessStatusEnum.BUSINESS_INVALID.equals((Object)storageOssBusiness.getStorageTypeBusinessStatus()) || StorageTypeBusinessStatusEnum.STORAGE_LINK_INVALID.equals((Object)storageOssBusiness.getStorageTypeBusinessStatus())) {
            throw new StorageSyncException(storageOssBusiness.storageTypeBusinessStatus.getMessage());
        }
        storageBucket.setStorageType(storageUploadParams.getStorageType());
        storageBucket.setBucketName(storageUploadParams.getModuleName());
        InterceptorCallback callback = new InterceptorCallback(this.interceptorManage, storageUploadParams);
        RecordAccumulator.RecordAppendResult recordAppendResult = this.recordAccumulator.append(storageBucket, storageUploadParams, callback);
        return recordAppendResult.futureRecordResult;
    }

    private StorageOssBusiness waitMetaData(int storageType, String businessCode) {
        Set validStorageType = this.metaData.getSupportStorageType();
        if (!validStorageType.contains(storageType)) {
            return new StorageOssBusiness(StorageTypeBusinessStatusEnum.STORAGE_LINK_INVALID);
        }
        Map storageBusinessCodeMap = this.metaData.getStorageBusinessCodeMap();
        if (storageBusinessCodeMap.containsKey(storageType)) {
            Set businessCodeSet = (Set)storageBusinessCodeMap.get(storageType);
            if (!businessCodeSet.contains(businessCode)) {
                return new StorageOssBusiness(StorageTypeBusinessStatusEnum.BUSINESS_INVALID);
            }
        } else {
            return new StorageOssBusiness(StorageTypeBusinessStatusEnum.STORAGE_LINK_INVALID);
        }
        return new StorageOssBusiness(StorageTypeBusinessStatusEnum.BUSINESS_STORAGE_VALID);
    }

    private static class InterceptorCallback
    implements Callback {
        private final ProducerInterceptorManage manage;
        private final StorageUploadParamsDTO storageUploadParams;

        public InterceptorCallback(ProducerInterceptorManage manage, StorageUploadParamsDTO storageUploadParams) {
            this.manage = manage;
            this.storageUploadParams = storageUploadParams;
        }

        @Override
        public void complete(Exception exception, UploadUrlResult uploadResult) {
            this.manage.ackResponse(uploadResult, exception, this.storageUploadParams);
        }
    }

    private static class StorageOssBusiness {
        private final StorageTypeBusinessStatusEnum storageTypeBusinessStatus;

        public StorageOssBusiness(StorageTypeBusinessStatusEnum storageTypeBusinessStatus) {
            this.storageTypeBusinessStatus = storageTypeBusinessStatus;
        }

        public StorageTypeBusinessStatusEnum getStorageTypeBusinessStatus() {
            return this.storageTypeBusinessStatus;
        }
    }
}

