/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.send;

import com.ovopark.dc.processor.entity.FileRecordBuilder;
import com.ovopark.dc.processor.send.Send;
import com.ovopark.dc.storage.broker.client.listener.AliyunUploadProgressListener;
import com.ovopark.dc.storage.broker.client.listener.UploadProgressListener;
import com.ovopark.dc.storage.broker.client.upload.AbstractUploadClient;
import com.ovopark.dc.storage.broker.model.dto.StorageBucketDTO;
import com.ovopark.dc.storage.broker.model.dto.StorageUploadParamsDTO;
import com.ovopark.dc.storage.broker.model.dto.UploadProgressDTO;
import com.ovopark.dc.storage.broker.model.enums.SendStateEnum;
import com.ovopark.dc.storage.broker.model.enums.StorageTypeEnum;
import com.ovopark.dc.storage.broker.model.result.OssUploadBatchResult;
import com.ovopark.dc.storage.broker.model.result.OssUploadResult;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunUploadSend
extends Send {
    private static final Logger log = LoggerFactory.getLogger(AliyunUploadSend.class);
    private final ExecutorService service;
    private final AbstractUploadClient client;

    public AliyunUploadSend(Map<StorageBucketDTO, FileRecordBuilder> record, ThreadPoolExecutor executor, AbstractUploadClient client) {
        super(record);
        this.storageTypeEnum = StorageTypeEnum.aliyun;
        if (executor == null) {
            executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(record.size());
        }
        this.service = executor;
        this.client = client;
    }

    @Override
    public int storage() {
        return this.storageTypeEnum.getValue();
    }

    @Override
    public void internalUpload() {
        for (Map.Entry entry : this.record.entrySet()) {
            OssUploadBatchResult ossUploadResult = new OssUploadBatchResult();
            FileRecordBuilder builder = (FileRecordBuilder)entry.getValue();
            if (builder == null || builder.records().isEmpty()) {
                this.result.put(entry.getKey(), ossUploadResult);
                continue;
            }
            HashMap<String, Future<OssUploadResult>> pathUploadResult = new HashMap<String, Future<OssUploadResult>>();
            HashMap<String, UploadProgressDTO> pathUploadPercent = new HashMap<String, UploadProgressDTO>();
            for (StorageUploadParamsDTO storageUploadParam : builder.records()) {
                UploadProgressDTO uploadProgress = new UploadProgressDTO(storageUploadParam);
                AliyunUploadProgressListener listener = new AliyunUploadProgressListener(uploadProgress);
                Future<OssUploadResult> uploadFuture = this.service.submit(new UploadTask(storageUploadParam, listener, this.client));
                pathUploadResult.put(storageUploadParam.getFileStoragePath(), uploadFuture);
                pathUploadPercent.put(storageUploadParam.getFileStoragePath(), uploadProgress);
            }
            ossUploadResult.setPathUploadResult(pathUploadResult);
            ossUploadResult.setPathUploadPercent(pathUploadPercent);
            this.result.put(entry.getKey(), ossUploadResult);
        }
        this.sendState = SendStateEnum.FINISH;
    }

    public static class UploadTask
    implements Callable<OssUploadResult> {
        private final StorageUploadParamsDTO storageUploadParam;
        private final AliyunUploadProgressListener listener;
        private final AbstractUploadClient client;

        public UploadTask(StorageUploadParamsDTO storageUploadParam, AliyunUploadProgressListener listener, AbstractUploadClient client) {
            this.client = client;
            this.storageUploadParam = storageUploadParam;
            this.listener = listener;
        }

        @Override
        public OssUploadResult call() {
            try {
                return this.client.uploadFile(this.storageUploadParam, (UploadProgressListener)this.listener);
            }
            catch (Throwable e) {
                log.error("aliyunUploadSend\u4e0a\u4f20\u51fa\u73b0\u4e86\u95ee\u9898\uff1a{}", (Object)e.toString());
                e.printStackTrace();
                return new OssUploadResult(e);
            }
        }
    }
}

