/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.send;

import com.ovopark.dc.processor.entity.FileRecordBuilder;
import com.ovopark.dc.storage.broker.model.dto.StorageBucketDTO;
import com.ovopark.dc.storage.broker.model.enums.SendStateEnum;
import com.ovopark.dc.storage.broker.model.enums.StorageTypeEnum;
import com.ovopark.dc.storage.broker.model.result.OssUploadBatchResult;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Send {
    private static final Logger log = LoggerFactory.getLogger(Send.class);
    protected SendStateEnum sendState = SendStateEnum.PREPARE;
    protected final Map<StorageBucketDTO, FileRecordBuilder> record;
    protected Map<StorageBucketDTO, OssUploadBatchResult> result;
    protected StorageTypeEnum storageTypeEnum;

    public Send(Map<StorageBucketDTO, FileRecordBuilder> record) {
        this.record = record;
        this.result = new HashMap<StorageBucketDTO, OssUploadBatchResult>();
    }

    public boolean completed() {
        return this.sendState == SendStateEnum.FINISH;
    }

    public boolean uploadSuccess() {
        for (OssUploadBatchResult batchResult : this.result.values()) {
            if (!batchResult.success()) continue;
            return true;
        }
        return false;
    }

    public boolean receiveResult() {
        for (OssUploadBatchResult batchResult : this.result.values()) {
            if (batchResult.finish()) continue;
            return false;
        }
        return true;
    }

    public void upload() {
        if (this.sendState == SendStateEnum.PREPARE) {
            this.sendState = SendStateEnum.SENDING;
            this.internalUpload();
        } else if (this.sendState == SendStateEnum.SENDING) {
            log.info("\u6b63\u5728\u53d1\u9001");
        }
    }

    public Map<StorageBucketDTO, OssUploadBatchResult> result() {
        if (this.completed()) {
            return this.result;
        }
        return null;
    }

    public abstract int storage();

    public abstract void internalUpload();
}

