/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.processor.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class CopyWriteMap<K, V>
implements ConcurrentMap<K, V> {
    private volatile Map<K, V> map = Collections.emptyMap();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        HashMap<K, V> copy = new HashMap<K, V>(this.map);
        V prev = copy.put(key, value);
        this.map = Collections.unmodifiableMap(copy);
        return prev;
    }

    @Override
    public V remove(Object key) {
        HashMap<K, V> copy = new HashMap<K, V>(this.map);
        Object prev = copy.remove(key);
        this.map = Collections.unmodifiableMap(copy);
        return prev;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        HashMap<? extends K, ? extends V> copy = new HashMap<K, V>(this.map);
        copy.putAll(m);
        this.map = Collections.unmodifiableMap(copy);
    }

    @Override
    public void clear() {
        this.map = Collections.emptyMap();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            return this.put(key, value);
        }
        return this.get(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.containsKey(key) && this.get(key).equals(value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.containsKey(key) && this.get(key).equals(oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        if (this.containsKey(key)) {
            return this.put(key, value);
        }
        return null;
    }
}

