/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.common.util;

import com.ovopark.dc.storage.broker.common.util.MyClock;
import com.ovopark.dc.storage.broker.common.util.VerifyBO;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    private static final String SECRET_KEY = "0123456789_0123456789_0123456789";
    private static final long TOKEN_EXPIRE_MILLIS = 3600000L;

    public static String createToken(Map<String, Object> claimMap, Date expiredDate) {
        Date date = null;
        long currentTimeMillis = System.currentTimeMillis() + 28800000L;
        if (expiredDate == null) {
            date = new Date(currentTimeMillis + 3600000L);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expiredDate);
            calendar.add(10, 8);
            date = calendar.getTime();
        }
        return Jwts.builder().setId(UUID.randomUUID().toString()).setIssuedAt(new Date(currentTimeMillis)).setExpiration(date).addClaims(claimMap).signWith(JwtUtils.generateKey()).compact();
    }

    public static VerifyBO verifyToken(String token) {
        VerifyBO verifyBO = new VerifyBO();
        try {
            MyClock clock = new MyClock();
            Jwts.parserBuilder().setClock((Clock)clock).setSigningKey(JwtUtils.generateKey()).build().parseClaimsJws(token);
            verifyBO.setCode(0);
            verifyBO.setMsg(null);
            return verifyBO;
        }
        catch (ExpiredJwtException e) {
            String msg = e.getMessage().replaceAll("JWT", "Token");
            log.error("token: {} error msg: {}", (Object)token, (Object)msg);
            verifyBO.setCode(1);
            verifyBO.setMsg(msg);
            return verifyBO;
        }
        catch (UnsupportedJwtException e) {
            String msg = e.getMessage().replaceAll("JWT", "Token");
            log.error("token: {} error msg: {}", (Object)token, (Object)msg);
            verifyBO.setCode(2);
            verifyBO.setMsg(msg);
            return verifyBO;
        }
        catch (MalformedJwtException e) {
            String msg = e.getMessage().replaceAll("JWT", "Token");
            log.error("token: {} error msg: {}", (Object)token, (Object)msg);
            verifyBO.setCode(3);
            verifyBO.setMsg(msg);
            return verifyBO;
        }
        catch (SignatureException e) {
            String msg = e.getMessage().replaceAll("JWT", "Token");
            log.error("token: {} error msg: {}", (Object)token, (Object)msg);
            verifyBO.setCode(4);
            verifyBO.setMsg(msg);
            return verifyBO;
        }
        catch (IllegalArgumentException e) {
            String msg = e.getMessage().replaceAll("JWT", "Token");
            log.error("token: {} error msg: {}", (Object)token, (Object)msg);
            verifyBO.setCode(5);
            verifyBO.setMsg(msg);
            return verifyBO;
        }
    }

    public static Map<String, Object> parseToken(String token) {
        return (Map)Jwts.parserBuilder().setSigningKey(JwtUtils.generateKey()).build().parseClaimsJws(token).getBody();
    }

    public static Key generateKey() {
        return new SecretKeySpec(SECRET_KEY.getBytes(), SignatureAlgorithm.HS256.getJcaName());
    }
}

