/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.balance;

import com.ovopark.dc.balance.Balance;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class PoolingBalance
implements Balance {
    private final int SHARDS = Runtime.getRuntime().availableProcessors();
    private final AtomicInteger[] shards = new AtomicInteger[this.SHARDS];

    @Override
    public void init() {
        for (int i = 0; i < this.SHARDS; ++i) {
            this.shards[i] = new AtomicInteger(0);
        }
    }

    @Override
    public int nextIndex(int size) {
        if (size == 0) {
            return -1;
        }
        int shardId = ThreadLocalRandom.current().nextInt(this.SHARDS);
        return this.shards[shardId].getAndIncrement() % size;
    }
}

