/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.cache;

import com.ovopark.dc.cache.Buffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public class ArrayBlockingQueueBuffer<T>
implements Buffer<T> {
    private ArrayBlockingQueue<T> queue;
    private int size;

    public ArrayBlockingQueueBuffer(int size) {
        this.queue = new ArrayBlockingQueue(size);
        this.size = size;
    }

    @Override
    public int write(T data) {
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            return 0;
        }
        return 1;
    }

    @Override
    public List<T> read() {
        return new ArrayList<T>(this.queue);
    }

    @Override
    public List<T> drain() {
        ArrayList result = new ArrayList();
        this.queue.drainTo(result);
        return result;
    }

    @Override
    public int getBufferSize() {
        return this.size;
    }
}

