/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.cache.consumer;

import com.ovopark.dc.cache.consumer.IConsumer;
import com.ovopark.dc.cache.consumer.IConsumerPool;
import com.ovopark.dc.cache.consumer.SelectorConsumer;
import com.ovopark.dc.cache.produce.Channel;
import java.util.ArrayList;
import java.util.List;

public class ConsumerPool
implements IConsumerPool {
    private boolean start = false;
    private List<SelectorConsumer> allConsumer;

    public ConsumerPool(int size, long consumerCycle, String name) {
        this.allConsumer = new ArrayList<SelectorConsumer>(size);
        for (int index = 0; index < size; ++index) {
            String selectorName = name + " consumer pool- selector " + index;
            SelectorConsumer selectorConsumer = new SelectorConsumer(consumerCycle, selectorName);
            selectorConsumer.setDaemon(true);
            this.allConsumer.add(selectorConsumer);
        }
    }

    @Override
    public void add(Channel channel, IConsumer consumer) {
        SelectorConsumer minSelector = this.allConsumer.get(0);
        if (this.allConsumer.size() > 1) {
            for (SelectorConsumer selectorConsumer : this.allConsumer) {
                if (minSelector.getSize() <= selectorConsumer.getSize()) continue;
                minSelector = selectorConsumer;
            }
        }
        minSelector.addGroup(channel, consumer);
    }

    @Override
    public boolean running() {
        return this.start;
    }

    @Override
    public void start() {
        if (this.start) {
            return;
        }
        for (SelectorConsumer consumer : this.allConsumer) {
            consumer.start();
        }
        this.start = true;
    }

    @Override
    public void shutdown() {
        if (this.start) {
            for (SelectorConsumer selectorConsumer : this.allConsumer) {
                selectorConsumer.shutdown();
            }
        }
        this.start = false;
    }

    public static int recommendMaxSize() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }
}

