/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.cache.produce;

import com.ovopark.dc.cache.ArrayBlockingQueueBuffer;
import com.ovopark.dc.cache.Buffer;
import com.ovopark.dc.cache.produce.IPartitioner;
import java.util.ArrayList;
import java.util.List;

public class Channel<T> {
    private List<Buffer<T>> channel;
    private long size;
    private IPartitioner<T> partitioner;
    private String name;

    public Channel(String name, int bufferSize, int channelSize, IPartitioner<T> partitioner) {
        this.name = name;
        this.partitioner = partitioner;
        this.channel = new ArrayList<Buffer<T>>(channelSize);
        for (int index = 0; index < channelSize; ++index) {
            this.channel.add(new ArrayBlockingQueueBuffer(bufferSize));
        }
        this.size = (long)bufferSize * (long)channelSize;
    }

    public int getChannelSize() {
        return this.channel.size();
    }

    public long getSize() {
        return this.size;
    }

    public boolean save(T data) {
        int index = 0;
        if (this.channel.size() > 1) {
            index = this.partitioner.partition(this.channel.size(), data);
        }
        for (int tryCount = this.partitioner.maxTry(); tryCount > 0; --tryCount) {
            if (this.channel.get(index).write(data) <= 0) continue;
            return true;
        }
        return false;
    }

    public Buffer<T> getBuffer(int index) {
        return this.channel.get(index);
    }
}

