/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.context;

import java.util.concurrent.ConcurrentHashMap;

public class RequestContext {
    private static volatile Class<? extends RequestContext> contextClass = RequestContext.class;
    private final ConcurrentHashMap<String, Object> data = new ConcurrentHashMap();
    protected static final ThreadLocal<RequestContext> THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        try {
            return contextClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Context initialization failed", e);
        }
    });

    public static RequestContext getCurrentContext() {
        return THREAD_LOCAL.get();
    }

    public <T> T getValue(String key, Class<T> type) {
        Object object = this.data.get(key);
        if (object == null) {
            return null;
        }
        return (T)object;
    }

    public void set(String key, Object value) {
        this.data.put(key, value);
    }

    public static void clear() {
        THREAD_LOCAL.remove();
    }
}

