/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.encode;

import com.ovopark.dc.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class URLEncoder {
    public static final URLEncoder PATH = URLEncoder.createPathUrlEncoder();
    public static final URLEncoder FORM_VALUE = URLEncoder.createFormUrlEncodedValue();
    private static final char[] PATH_EXCLUDED_CHARACTERS = new char[]{'-', '.', '_', '+', '!', '(', ')', '[', ']', '*', '/', ':', '?', '=', '$', '@', '&', '~'};
    private static final char[] HEX_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] X_WWW_FORM_URLENCODED_VALUE_EXCLUDED_CHARACTERS = new char[]{'-', '.', '_', '!', '{', '}', '[', ']', ',', '\"', '*', '/', ':', '?', '#', '='};
    private boolean encodeSpaceAsPlus = false;
    private final BitSet excludedCharacters = new BitSet(256);

    public URLEncoder() {
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.excludeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.excludeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.excludeCharacter(i);
        }
    }

    public static URLEncoder createPathUrlEncoder() {
        return URLEncoder.createURLEncoder(PATH_EXCLUDED_CHARACTERS, false);
    }

    public static URLEncoder createFormUrlEncodedValue() {
        return URLEncoder.createURLEncoder(X_WWW_FORM_URLENCODED_VALUE_EXCLUDED_CHARACTERS, false);
    }

    private static URLEncoder createURLEncoder(char[] excludedCharacters, boolean encodeSpaceAsPlus) {
        URLEncoder encoder = new URLEncoder();
        encoder.setEncodeSpaceAsPlus(encodeSpaceAsPlus);
        for (char ch : excludedCharacters) {
            encoder.excludeCharacter(ch);
        }
        return encoder;
    }

    public String encode(String path, String charset) {
        if (path == null) {
            return null;
        }
        Charset cs = StringUtils.isEmpty(charset) ? StandardCharsets.UTF_8 : Charset.forName(charset);
        return this.encode(path, cs);
    }

    public String encode(String path, Charset charset) {
        StringBuilder sb = new StringBuilder(path.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);
        char[] chars = path.toCharArray();
        for (int index = 0; index < chars.length; ++index) {
            byte[] bytes;
            char ch = chars[index];
            if (this.isUrlEncoded(chars, index)) {
                sb.append(ch);
                continue;
            }
            if (this.excludedCharacters.get(ch)) {
                sb.append(ch);
                continue;
            }
            if (this.encodeSpaceAsPlus && ch == ' ') {
                sb.append('+');
                continue;
            }
            try {
                writer.write(ch);
                writer.flush();
            }
            catch (Exception exception) {
                out.reset();
                continue;
            }
            for (byte b : bytes = out.toByteArray()) {
                sb.append('%');
                int high = (b & 0xF0) >> 4;
                int low = b & 0xF;
                sb.append(HEX_DIGITS_UPPER[high]);
                sb.append(HEX_DIGITS_UPPER[low]);
            }
        }
        return sb.toString();
    }

    private boolean isUrlEncoded(char[] ch, int index) {
        if (ch[index] != '%') {
            return false;
        }
        int len = ch.length;
        if (index + 2 < len) {
            char ch1 = ch[index + 1];
            char ch2 = ch[index + 2];
            return this.isHexChar(ch1) && this.isHexChar(ch2);
        }
        return false;
    }

    private boolean isHexChar(char ch) {
        if (Character.isDigit(ch)) {
            return true;
        }
        switch (ch) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public void setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public void excludeCharacter(char c) {
        this.excludedCharacters.set(c);
    }
}

