/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileCommonUtils {
    public static List<File> doConvertToMultiPartFiles(File file, int chunkSize, String dirName) {
        ArrayList<File> multipartFiles = new ArrayList<File>();
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[chunkSize];
            int partNumber = 0;
            while ((bytesRead = fis.read(buffer)) != -1) {
                String outputFileName = dirName + "\\part" + partNumber;
                File partFile = new File(outputFileName);
                if (!partFile.exists()) {
                    if (!partFile.getParentFile().exists()) {
                        partFile.getParentFile().mkdirs();
                    }
                    partFile.createNewFile();
                }
                try (FileOutputStream fos = new FileOutputStream(outputFileName);){
                    fos.write(buffer, 0, bytesRead);
                }
                multipartFiles.add(partFile);
                ++partNumber;
            }
        }
        catch (IOException e) {
            return null;
        }
        return multipartFiles;
    }
}

