/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.io;

import java.io.IOException;
import java.io.Writer;

public class StringPrintWriter
extends Writer {
    private StringBuilder buffer = new StringBuilder();

    public StringPrintWriter() {
        this.lock = this.buffer;
    }

    @Override
    public void write(char[] cs, int off, int len) throws IOException {
        if (off < 0 || off > cs.length || len < 0 || off + len > cs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len > 0) {
            this.buffer.append(cs, off, len);
        }
    }

    @Override
    public void write(int c) {
        this.buffer.append((char)c);
    }

    @Override
    public void write(char[] cs) throws IOException {
        this.buffer.append(cs, 0, cs.length);
    }

    @Override
    public void write(String str) {
        this.buffer.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buffer.append(str, off, off + len);
    }

    @Override
    public Writer append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public Writer append(char c) {
        this.buffer.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.buffer.toString();
    }
}

