/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.time;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StopWatch {
    private final String taskName;
    private long startTotalTimeMilli;
    private long endTotalTimeMilli;
    private Map<String, List<TaskInfo>> taskInfoMap;

    public StopWatch(String taskName) {
        this.taskName = taskName;
        this.taskInfoMap = new LinkedHashMap<String, List<TaskInfo>>();
    }

    public void start(String currentTaskName) {
        TaskInfo taskInfo = new TaskInfo(currentTaskName);
        taskInfo.start();
        if (this.startTotalTimeMilli == 0L) {
            this.startTotalTimeMilli = taskInfo.getStartTimeMilli();
        }
        List taskInfoList = this.taskInfoMap.computeIfAbsent(currentTaskName, k -> new ArrayList());
        taskInfoList.add(taskInfo);
    }

    public void end(String currentTaskName) {
        if (!this.taskInfoMap.containsKey(currentTaskName)) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        List<TaskInfo> taskInfoList = this.taskInfoMap.get(currentTaskName);
        if (taskInfoList.isEmpty()) {
            return;
        }
        TaskInfo taskInfo = taskInfoList.get(taskInfoList.size() - 1);
        taskInfo.end();
        this.endTotalTimeMilli = taskInfo.getEndTimeMilli();
    }

    public long getTotalTimeMilli() {
        return this.endTotalTimeMilli - this.startTotalTimeMilli;
    }

    public String prettyPrint() {
        StringBuilder pretty = new StringBuilder();
        long totalTime = this.endTotalTimeMilli - this.startTotalTimeMilli;
        pretty.append(this.taskName);
        pretty.append(" -> time:");
        pretty.append(totalTime);
        pretty.append("ms \n");
        if (this.taskInfoMap.isEmpty()) {
            pretty.append("no task");
        } else {
            int index = 1;
            for (Map.Entry<String, List<TaskInfo>> entry : this.taskInfoMap.entrySet()) {
                long time = entry.getValue().stream().filter(item -> item.getEndTimeMilli() != 0L).mapToLong(item -> item.getEndTimeMilli() - item.getStartTimeMilli()).sum();
                double percentTrue = 100.0 * ((double)time / (double)totalTime);
                pretty.append(index);
                pretty.append(". ");
                pretty.append(entry.getKey());
                pretty.append(", time:");
                pretty.append(time);
                pretty.append(", percent:");
                pretty.append(String.format("%.3f", percentTrue));
                pretty.append("% \n");
            }
        }
        return pretty.toString();
    }

    public static final class TaskInfo {
        private final String taskName;
        private long startTimeMilli;
        private long endTimeMilli;

        public TaskInfo(String taskName) {
            this.taskName = taskName;
        }

        public void start() {
            this.startTimeMilli = System.currentTimeMillis();
        }

        public void end() {
            this.endTimeMilli = System.currentTimeMillis();
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getStartTimeMilli() {
            return this.startTimeMilli;
        }

        public long getEndTimeMilli() {
            return this.endTimeMilli;
        }
    }
}

