/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.time;

import com.ovopark.dc.time.TimeThread;
import com.ovopark.dc.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeService {
    public static final String DATE_FORMAT_DATE_ONLY = "yyyy-MM-dd";
    public static final String DATE_FORMAT_TIME_ONLY = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DATE_PATH_ONLY = "yyyy/MM/dd";
    public static String FORMAT_SHORT = "yyyy-MM-dd";
    public static String FORMAT_LONG = "yyyy-MM-dd HH:mm:ss";
    public static String FORMAT_NO_SECNOD = "yyyy-MM-dd HH:mm";

    public static String getDate() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DATE_ONLY);
        format.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        return format.format(TimeThread.currentTimeMillis());
    }

    public static String getTime() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_TIME_ONLY);
        format.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        return format.format(TimeThread.currentTimeMillis());
    }

    public static String getDatePath() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DATE_PATH_ONLY);
        format.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        return format.format(TimeThread.currentTimeMillis());
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date changeStr2Date(String time) {
        if (StringUtils.isEmpty(time)) {
            return null;
        }
        int shortLen = FORMAT_SHORT.length();
        int longLen = FORMAT_LONG.length();
        int noSecondLen = FORMAT_NO_SECNOD.length();
        if (time.length() == shortLen) {
            return TimeService.parse(time, FORMAT_SHORT);
        }
        if (time.length() == longLen) {
            return TimeService.parse(time, FORMAT_LONG);
        }
        if (time.length() == noSecondLen) {
            return TimeService.parse(time, FORMAT_NO_SECNOD);
        }
        return time.length() == 13 ? new Date(Long.valueOf(time)) : null;
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException var4) {
            var4.printStackTrace();
            return null;
        }
    }
}

