/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.util;

import com.ovopark.dc.time.TimeThread;
import java.util.HashMap;
import java.util.Map;

public class LruCache<T, R>
implements Runnable {
    private int size;
    private int capacity;
    private Map<T, Node> cache;
    private Node head;
    private Node tail;
    private String name;

    @Override
    public void run() {
        for (Map.Entry<T, Node> entry : this.cache.entrySet()) {
            if (TimeThread.currentTimeMillis() - entry.getValue().time <= 1800000L) continue;
            this.remove(entry.getValue());
            this.cache.remove(entry.getKey());
            this.removeNodeProcess(this.tail.key, this.tail.value);
        }
        try {
            Thread.sleep(1800000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public LruCache(int capacity, String name) {
        this.capacity = capacity;
        this.size = 0;
        this.cache = new HashMap<T, Node>();
        this.head = new Node();
        this.tail = new Node();
        this.name = name;
        this.head.next = this.tail;
        this.tail.prev = this.head;
        Thread thread = new Thread(this);
        thread.setName(this.name);
        thread.start();
    }

    public R put(T key, R value) {
        Node node = this.cache.get(key);
        if (node == null) {
            Node newNode = new Node(key, value);
            this.cache.put(key, newNode);
            this.addHead(newNode);
            ++this.size;
            if (this.size > this.capacity) {
                Node tail = this.removeTail();
                this.cache.remove(tail.key);
                --this.size;
            }
        } else {
            node.value = value;
            this.moveHead(node);
        }
        return value;
    }

    public R get(T key) {
        Node node = this.cache.get(key);
        if (node == null) {
            return null;
        }
        this.moveHead(node);
        return node.value;
    }

    private void moveHead(Node newNode) {
        this.remove(newNode);
        this.addHead(newNode);
    }

    private void addHead(Node node) {
        node.prev = this.head;
        node.next = this.head.next;
        this.head.next.prev = node;
        this.head.next = node;
        this.moveHeadProcess(node.key, node.value);
        node.updateTime();
    }

    private void remove(Node node) {
        node.prev.next = node.next;
        node.next.prev = node.prev;
    }

    private Node removeTail() {
        Node tail = this.tail.prev;
        this.remove(tail);
        this.removeNodeProcess(tail.key, tail.value);
        return tail;
    }

    public void removeNodeProcess(T key, R value) {
    }

    public void moveHeadProcess(T key, R value) {
    }

    class Node {
        T key;
        R value;
        Node next;
        Node prev;
        long time;

        public Node() {
            this.updateTime();
        }

        public Node(T key, R value) {
            this.key = key;
            this.value = value;
            this.updateTime();
        }

        public void updateTime() {
            this.time = TimeThread.currentTimeMillis();
        }
    }
}

