/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtils {
    public static HostInfo getLocalHost() {
        InetAddress inetAddress = NetUtils.getFirstNonLoopAddress();
        if (inetAddress != null) {
            return NetUtils.convert(inetAddress);
        }
        return null;
    }

    public static InetAddress getFirstNonLoopAddress() {
        InetAddress address = null;
        try {
            int low = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp()) continue;
                if (networkInterface.getIndex() < low || address == null) {
                    low = networkInterface.getIndex();
                } else if (address != null) continue;
                Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress inetAddress = addrs.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                    address = inetAddress;
                }
            }
        }
        catch (Exception low) {
            // empty catch block
        }
        if (address != null) {
            return address;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static HostInfo convert(InetAddress inetAddress) {
        HostInfo hostInfo = new HostInfo();
        hostInfo.setHostName(inetAddress.getHostName());
        hostInfo.setIpAddress(inetAddress.getHostAddress());
        return hostInfo;
    }

    public static String getLocalIpAddress() {
        HostInfo hostInfo = NetUtils.getLocalHost();
        return hostInfo == null ? "127.0.0.1" : hostInfo.getIpAddress();
    }

    public static class HostInfo {
        private String hostName;
        private String ipAddress;
        private Integer port;

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }
    }
}

