/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class ReflectUtil {
    public static final char VOID = 'V';
    public static final char BOOLEAN = 'Z';
    public static final char BYTE = 'B';
    public static final char CHAR = 'C';
    public static final char DOUBLE = 'D';
    public static final char FLOAT = 'F';
    public static final char INT = 'I';
    public static final char LONG = 'L';
    public static final char SHORT = 'S';

    public static String getName(Class<?> clazz) {
        if (clazz.isArray()) {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append("[]");
            } while ((clazz = clazz.getComponentType()).isArray());
            return clazz.getName() + sb.toString();
        }
        return clazz.getName();
    }

    public static String getSign(Method method) {
        StringBuilder sb = new StringBuilder().append(method.getName()).append("(");
        for (Class<?> param : method.getParameterTypes()) {
            sb.append(ReflectUtil.getSign(param) + ",");
        }
        sb.append(")").append(ReflectUtil.getSign(method.getReturnType()));
        return sb.toString();
    }

    public static String getSign(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        while (clazz.isArray()) {
            sb.append("[");
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            String name;
            switch (name = clazz.getName()) {
                case "byte": {
                    sb.append('V');
                    break;
                }
                case "short": {
                    sb.append('S');
                    break;
                }
                case "int": {
                    sb.append('I');
                    break;
                }
                case "long": {
                    sb.append('L');
                    break;
                }
                case "float": {
                    sb.append('F');
                    break;
                }
                case "double": {
                    sb.append('D');
                    break;
                }
                case "char": {
                    sb.append('C');
                }
            }
        } else {
            sb.append("L").append(clazz.getName().replace(".", "/")).append(";");
        }
        return sb.toString();
    }

    public static boolean isPrimitives(Class<?> clazz) {
        if (clazz.isArray()) {
            return ReflectUtil.isPrimitives(clazz.getComponentType());
        }
        return ReflectUtil.isPrimitive(clazz);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Character.class;
    }

    public static Class<?> toClass(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getRawType();
        }
        if (genericType instanceof TypeVariable) {
            return (Class)((TypeVariable)genericType).getBounds()[0];
        }
        if (genericType instanceof WildcardType && "?".equals(genericType.toString())) {
            return Object.class;
        }
        try {
            return (Class)genericType;
        }
        catch (Throwable th) {
            return Object.class;
        }
    }
}

