/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.util;

import com.ovopark.dc.io.StringPrintWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class StringUtils {
    public static boolean isEmpty(String data) {
        return data == null || "".equals(data) || " ".equals(data) || data.length() == 0;
    }

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && StringUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String limitMessage(String message, int index) {
        if (StringUtils.isEmpty(message)) {
            return "null";
        }
        return message.substring(0, Math.min(index, message.length()));
    }

    public static boolean isNotEmpty(String data) {
        return !StringUtils.isEmpty(data);
    }

    public static String toCamelCase(String data) {
        if (StringUtils.isEmpty(data)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(data.length());
        boolean upper = false;
        for (int index = 0; index < data.length(); ++index) {
            char ch = data.charAt(index);
            if (ch == '-') {
                upper = true;
                continue;
            }
            if (upper) {
                stringBuilder.append(Character.toUpperCase(ch));
                upper = false;
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    public static String subAfter(String str, String separator, boolean isLastSeparator) {
        if (StringUtils.isEmpty(str)) {
            return str == null ? null : str.toString();
        }
        if (separator == null) {
            return "";
        }
        int pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        return pos == -1 ? "" : str.substring(pos + separator.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exceptionToString(Throwable throwable) {
        StringPrintWriter printWriter = new StringPrintWriter();
        PrintWriter writer = new PrintWriter(printWriter);
        writer.print(throwable.getClass().getName());
        if (throwable.getMessage() != null) {
            writer.print(": " + throwable.getMessage());
        }
        writer.println();
        try {
            throwable.printStackTrace(writer);
            String string = printWriter.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    public static String fromBytes(byte[] bytes, Charset charset, Charset defaultCharset) {
        if (charset == null) {
            charset = defaultCharset;
        }
        return new String(bytes, charset);
    }

    public static String generateBoundary() {
        UUID uuid = UUID.randomUUID();
        return StringUtils.fromBytes(uuid.toString().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8, StandardCharsets.UTF_8);
    }
}

