/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.loader.compiler;

import com.ovopark.dc.loader.compiler.Compiler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCompiler
implements Compiler {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+([a-zA-Z][$_a-zA-Z0-9\\.]*)");
    private static final Pattern CLASS_PATTERN = Pattern.compile("class\\s+([a-zA-Z][$_a-zA-Z0-9]*)\\s+");

    @Override
    public Class<?> compile(String code, ClassLoader classLoader) {
        Matcher classMatcher;
        String packageName = "";
        String className = "";
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(code);
        if (packageMatcher.find()) {
            packageName = packageMatcher.group(1);
        }
        if ((classMatcher = CLASS_PATTERN.matcher(code)).find()) {
            className = classMatcher.group(1);
        }
        String name = packageName + "." + className;
        try {
            return Class.forName(name, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException exception) {
            if (!code.endsWith("}")) {
                throw new IllegalStateException("The java code not endsWith \"}\", code: \n" + code + "\n");
            }
            try {
                return this.doCompile(name, code);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected abstract Class<?> doCompile(String var1, String var2);
}

